package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeControllerManagerBuilder extends KubeControllerManagerFluentImpl<KubeControllerManagerBuilder> implements VisitableBuilder<KubeControllerManager,KubeControllerManagerBuilder>{
  public KubeControllerManagerBuilder() {
    this(false);
  }
  public KubeControllerManagerBuilder(Boolean validationEnabled) {
    this(new KubeControllerManager(), validationEnabled);
  }
  public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeControllerManager(), validationEnabled);
  }
  public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent,KubeControllerManager instance) {
    this(fluent, instance, false);
  }
  public KubeControllerManagerBuilder(KubeControllerManagerFluent<?> fluent,KubeControllerManager instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeControllerManagerBuilder(KubeControllerManager instance) {
    this(instance,false);
  }
  public KubeControllerManagerBuilder(KubeControllerManager instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeControllerManagerFluent<?> fluent;
  Boolean validationEnabled;
  public KubeControllerManager build() {
    KubeControllerManager buildable = new KubeControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}