package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface KubeControllerManagerFluent<A extends KubeControllerManagerFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public KubeControllerManagerFluent.MetadataNested<A> withNewMetadata();
  public KubeControllerManagerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public KubeControllerManagerFluent.MetadataNested<A> editMetadata();
  public KubeControllerManagerFluent.MetadataNested<A> editOrNewMetadata();
  public KubeControllerManagerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeControllerManagerSpec getSpec();
  public KubeControllerManagerSpec buildSpec();
  public A withSpec(KubeControllerManagerSpec spec);
  public Boolean hasSpec();
  public KubeControllerManagerFluent.SpecNested<A> withNewSpec();
  public KubeControllerManagerFluent.SpecNested<A> withNewSpecLike(KubeControllerManagerSpec item);
  public KubeControllerManagerFluent.SpecNested<A> editSpec();
  public KubeControllerManagerFluent.SpecNested<A> editOrNewSpec();
  public KubeControllerManagerFluent.SpecNested<A> editOrNewSpecLike(KubeControllerManagerSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeControllerManagerStatus getStatus();
  public KubeControllerManagerStatus buildStatus();
  public A withStatus(KubeControllerManagerStatus status);
  public Boolean hasStatus();
  public KubeControllerManagerFluent.StatusNested<A> withNewStatus();
  public KubeControllerManagerFluent.StatusNested<A> withNewStatusLike(KubeControllerManagerStatus item);
  public KubeControllerManagerFluent.StatusNested<A> editStatus();
  public KubeControllerManagerFluent.StatusNested<A> editOrNewStatus();
  public KubeControllerManagerFluent.StatusNested<A> editOrNewStatusLike(KubeControllerManagerStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<KubeControllerManagerFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,KubeControllerManagerSpecFluent<KubeControllerManagerFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,KubeControllerManagerStatusFluent<KubeControllerManagerFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}