package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface KubeSchedulerFluent<A extends KubeSchedulerFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public KubeSchedulerFluent.MetadataNested<A> withNewMetadata();
  public KubeSchedulerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public KubeSchedulerFluent.MetadataNested<A> editMetadata();
  public KubeSchedulerFluent.MetadataNested<A> editOrNewMetadata();
  public KubeSchedulerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeSchedulerSpec getSpec();
  public KubeSchedulerSpec buildSpec();
  public A withSpec(KubeSchedulerSpec spec);
  public Boolean hasSpec();
  public KubeSchedulerFluent.SpecNested<A> withNewSpec();
  public KubeSchedulerFluent.SpecNested<A> withNewSpecLike(KubeSchedulerSpec item);
  public KubeSchedulerFluent.SpecNested<A> editSpec();
  public KubeSchedulerFluent.SpecNested<A> editOrNewSpec();
  public KubeSchedulerFluent.SpecNested<A> editOrNewSpecLike(KubeSchedulerSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeSchedulerStatus getStatus();
  public KubeSchedulerStatus buildStatus();
  public A withStatus(KubeSchedulerStatus status);
  public Boolean hasStatus();
  public KubeSchedulerFluent.StatusNested<A> withNewStatus();
  public KubeSchedulerFluent.StatusNested<A> withNewStatusLike(KubeSchedulerStatus item);
  public KubeSchedulerFluent.StatusNested<A> editStatus();
  public KubeSchedulerFluent.StatusNested<A> editOrNewStatus();
  public KubeSchedulerFluent.StatusNested<A> editOrNewStatusLike(KubeSchedulerStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<KubeSchedulerFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,KubeSchedulerSpecFluent<KubeSchedulerFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,KubeSchedulerStatusFluent<KubeSchedulerFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}