package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeSchedulerListBuilder extends KubeSchedulerListFluentImpl<KubeSchedulerListBuilder> implements VisitableBuilder<KubeSchedulerList,KubeSchedulerListBuilder>{
  public KubeSchedulerListBuilder() {
    this(false);
  }
  public KubeSchedulerListBuilder(Boolean validationEnabled) {
    this(new KubeSchedulerList(), validationEnabled);
  }
  public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeSchedulerList(), validationEnabled);
  }
  public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent,KubeSchedulerList instance) {
    this(fluent, instance, false);
  }
  public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent,KubeSchedulerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeSchedulerListBuilder(KubeSchedulerList instance) {
    this(instance,false);
  }
  public KubeSchedulerListBuilder(KubeSchedulerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeSchedulerListFluent<?> fluent;
  Boolean validationEnabled;
  public KubeSchedulerList build() {
    KubeSchedulerList buildable = new KubeSchedulerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}