package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeSchedulerStatusBuilder extends KubeSchedulerStatusFluentImpl<KubeSchedulerStatusBuilder> implements VisitableBuilder<KubeSchedulerStatus,KubeSchedulerStatusBuilder>{
  public KubeSchedulerStatusBuilder() {
    this(false);
  }
  public KubeSchedulerStatusBuilder(Boolean validationEnabled) {
    this(new KubeSchedulerStatus(), validationEnabled);
  }
  public KubeSchedulerStatusBuilder(KubeSchedulerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeSchedulerStatusBuilder(KubeSchedulerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeSchedulerStatus(), validationEnabled);
  }
  public KubeSchedulerStatusBuilder(KubeSchedulerStatusFluent<?> fluent,KubeSchedulerStatus instance) {
    this(fluent, instance, false);
  }
  public KubeSchedulerStatusBuilder(KubeSchedulerStatusFluent<?> fluent,KubeSchedulerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      fluent.withNodeStatuses(instance.getNodeStatuses());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeSchedulerStatusBuilder(KubeSchedulerStatus instance) {
    this(instance,false);
  }
  public KubeSchedulerStatusBuilder(KubeSchedulerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      this.withNodeStatuses(instance.getNodeStatuses());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeSchedulerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KubeSchedulerStatus build() {
    KubeSchedulerStatus buildable = new KubeSchedulerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.getNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}