package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeStorageVersionMigratorStatusBuilder extends KubeStorageVersionMigratorStatusFluentImpl<KubeStorageVersionMigratorStatusBuilder> implements VisitableBuilder<KubeStorageVersionMigratorStatus,KubeStorageVersionMigratorStatusBuilder>{
  public KubeStorageVersionMigratorStatusBuilder() {
    this(false);
  }
  public KubeStorageVersionMigratorStatusBuilder(Boolean validationEnabled) {
    this(new KubeStorageVersionMigratorStatus(), validationEnabled);
  }
  public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeStorageVersionMigratorStatus(), validationEnabled);
  }
  public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent,KubeStorageVersionMigratorStatus instance) {
    this(fluent, instance, false);
  }
  public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatusFluent<?> fluent,KubeStorageVersionMigratorStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatus instance) {
    this(instance,false);
  }
  public KubeStorageVersionMigratorStatusBuilder(KubeStorageVersionMigratorStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeStorageVersionMigratorStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KubeStorageVersionMigratorStatus build() {
    KubeStorageVersionMigratorStatus buildable = new KubeStorageVersionMigratorStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}