package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkFluent<A extends NetworkFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public NetworkFluent.MetadataNested<A> withNewMetadata();
  public NetworkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public NetworkFluent.MetadataNested<A> editMetadata();
  public NetworkFluent.MetadataNested<A> editOrNewMetadata();
  public NetworkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkSpec getSpec();
  public NetworkSpec buildSpec();
  public A withSpec(NetworkSpec spec);
  public Boolean hasSpec();
  public NetworkFluent.SpecNested<A> withNewSpec();
  public NetworkFluent.SpecNested<A> withNewSpecLike(NetworkSpec item);
  public NetworkFluent.SpecNested<A> editSpec();
  public NetworkFluent.SpecNested<A> editOrNewSpec();
  public NetworkFluent.SpecNested<A> editOrNewSpecLike(NetworkSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkStatus getStatus();
  public NetworkStatus buildStatus();
  public A withStatus(NetworkStatus status);
  public Boolean hasStatus();
  public NetworkFluent.StatusNested<A> withNewStatus();
  public NetworkFluent.StatusNested<A> withNewStatusLike(NetworkStatus item);
  public NetworkFluent.StatusNested<A> editStatus();
  public NetworkFluent.StatusNested<A> editOrNewStatus();
  public NetworkFluent.StatusNested<A> editOrNewStatusLike(NetworkStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<NetworkFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,NetworkSpecFluent<NetworkFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,NetworkStatusFluent<NetworkFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}