package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodePlacementBuilder extends NodePlacementFluentImpl<NodePlacementBuilder> implements VisitableBuilder<NodePlacement,NodePlacementBuilder>{
  public NodePlacementBuilder() {
    this(false);
  }
  public NodePlacementBuilder(Boolean validationEnabled) {
    this(new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance) {
    this(fluent, instance, false);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodePlacementBuilder(NodePlacement instance) {
    this(instance,false);
  }
  public NodePlacementBuilder(NodePlacement instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodePlacementFluent<?> fluent;
  Boolean validationEnabled;
  public NodePlacement build() {
    NodePlacement buildable = new NodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}