package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthAPIServerStatusBuilder extends OAuthAPIServerStatusFluentImpl<OAuthAPIServerStatusBuilder> implements VisitableBuilder<OAuthAPIServerStatus,OAuthAPIServerStatusBuilder>{
  public OAuthAPIServerStatusBuilder() {
    this(false);
  }
  public OAuthAPIServerStatusBuilder(Boolean validationEnabled) {
    this(new OAuthAPIServerStatus(), validationEnabled);
  }
  public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthAPIServerStatus(), validationEnabled);
  }
  public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent,OAuthAPIServerStatus instance) {
    this(fluent, instance, false);
  }
  public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent,OAuthAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthAPIServerStatusBuilder(OAuthAPIServerStatus instance) {
    this(instance,false);
  }
  public OAuthAPIServerStatusBuilder(OAuthAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthAPIServerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthAPIServerStatus build() {
    OAuthAPIServerStatus buildable = new OAuthAPIServerStatus(fluent.getLatestAvailableRevision());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}