package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface OpenShiftAPIServerListFluent<A extends OpenShiftAPIServerListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,OpenShiftAPIServer item);
  public A setToItems(int index,OpenShiftAPIServer item);
  public A addToItems(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer... items);
  public A addAllToItems(Collection<OpenShiftAPIServer> items);
  public A removeFromItems(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer... items);
  public A removeAllFromItems(Collection<OpenShiftAPIServer> items);
  public A removeMatchingFromItems(Predicate<OpenShiftAPIServerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OpenShiftAPIServer> getItems();
  public List<OpenShiftAPIServer> buildItems();
  public OpenShiftAPIServer buildItem(int index);
  public OpenShiftAPIServer buildFirstItem();
  public OpenShiftAPIServer buildLastItem();
  public OpenShiftAPIServer buildMatchingItem(Predicate<OpenShiftAPIServerBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<OpenShiftAPIServerBuilder> predicate);
  public A withItems(List<OpenShiftAPIServer> items);
  public A withItems(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer... items);
  public Boolean hasItems();
  public OpenShiftAPIServerListFluent.ItemsNested<A> addNewItem();
  public OpenShiftAPIServerListFluent.ItemsNested<A> addNewItemLike(OpenShiftAPIServer item);
  public OpenShiftAPIServerListFluent.ItemsNested<A> setNewItemLike(int index,OpenShiftAPIServer item);
  public OpenShiftAPIServerListFluent.ItemsNested<A> editItem(int index);
  public OpenShiftAPIServerListFluent.ItemsNested<A> editFirstItem();
  public OpenShiftAPIServerListFluent.ItemsNested<A> editLastItem();
  public OpenShiftAPIServerListFluent.ItemsNested<A> editMatchingItem(Predicate<OpenShiftAPIServerBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,OpenShiftAPIServerFluent<OpenShiftAPIServerListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}