package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftControllerManagerSpecBuilder extends OpenShiftControllerManagerSpecFluentImpl<OpenShiftControllerManagerSpecBuilder> implements VisitableBuilder<OpenShiftControllerManagerSpec,OpenShiftControllerManagerSpecBuilder>{
  public OpenShiftControllerManagerSpecBuilder() {
    this(false);
  }
  public OpenShiftControllerManagerSpecBuilder(Boolean validationEnabled) {
    this(new OpenShiftControllerManagerSpec(), validationEnabled);
  }
  public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftControllerManagerSpec(), validationEnabled);
  }
  public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent,OpenShiftControllerManagerSpec instance) {
    this(fluent, instance, false);
  }
  public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent,OpenShiftControllerManagerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpec instance) {
    this(instance,false);
  }
  public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenShiftControllerManagerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftControllerManagerSpec build() {
    OpenShiftControllerManagerSpec buildable = new OpenShiftControllerManagerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}