package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectAccessFluentImpl<A extends ProjectAccessFluent<A>> extends BaseFluent<A> implements ProjectAccessFluent<A>{
  public ProjectAccessFluentImpl() {
  }
  public ProjectAccessFluentImpl(ProjectAccess instance) {
    if (instance != null) {
      this.withAvailableClusterRoles(instance.getAvailableClusterRoles());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> availableClusterRoles = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToAvailableClusterRoles(int index,String item) {
    if (this.availableClusterRoles == null) {this.availableClusterRoles = new ArrayList<String>();}
    this.availableClusterRoles.add(index, item);
    return (A)this;
  }
  public A setToAvailableClusterRoles(int index,String item) {
    if (this.availableClusterRoles == null) {this.availableClusterRoles = new ArrayList<String>();}
    this.availableClusterRoles.set(index, item); return (A)this;
  }
  public A addToAvailableClusterRoles(java.lang.String... items) {
    if (this.availableClusterRoles == null) {this.availableClusterRoles = new ArrayList<String>();}
    for (String item : items) {this.availableClusterRoles.add(item);} return (A)this;
  }
  public A addAllToAvailableClusterRoles(Collection<String> items) {
    if (this.availableClusterRoles == null) {this.availableClusterRoles = new ArrayList<String>();}
    for (String item : items) {this.availableClusterRoles.add(item);} return (A)this;
  }
  public A removeFromAvailableClusterRoles(java.lang.String... items) {
    for (String item : items) {if (this.availableClusterRoles!= null){ this.availableClusterRoles.remove(item);}} return (A)this;
  }
  public A removeAllFromAvailableClusterRoles(Collection<String> items) {
    for (String item : items) {if (this.availableClusterRoles!= null){ this.availableClusterRoles.remove(item);}} return (A)this;
  }
  public List<String> getAvailableClusterRoles() {
    return this.availableClusterRoles;
  }
  public String getAvailableClusterRole(int index) {
    return this.availableClusterRoles.get(index);
  }
  public String getFirstAvailableClusterRole() {
    return this.availableClusterRoles.get(0);
  }
  public String getLastAvailableClusterRole() {
    return this.availableClusterRoles.get(availableClusterRoles.size() - 1);
  }
  public String getMatchingAvailableClusterRole(Predicate<String> predicate) {
    for (String item: availableClusterRoles) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAvailableClusterRole(Predicate<String> predicate) {
    for (String item: availableClusterRoles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAvailableClusterRoles(List<String> availableClusterRoles) {
    if (availableClusterRoles != null) {this.availableClusterRoles = new ArrayList(); for (String item : availableClusterRoles){this.addToAvailableClusterRoles(item);}} else { this.availableClusterRoles = null;} return (A) this;
  }
  public A withAvailableClusterRoles(java.lang.String... availableClusterRoles) {
    if (this.availableClusterRoles != null) {this.availableClusterRoles.clear(); _visitables.remove("availableClusterRoles"); }
    if (availableClusterRoles != null) {for (String item :availableClusterRoles){ this.addToAvailableClusterRoles(item);}} return (A) this;
  }
  public Boolean hasAvailableClusterRoles() {
    return availableClusterRoles != null && !availableClusterRoles.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProjectAccessFluentImpl that = (ProjectAccessFluentImpl) o;
    if (!java.util.Objects.equals(availableClusterRoles, that.availableClusterRoles)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableClusterRoles,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableClusterRoles != null && !availableClusterRoles.isEmpty()) { sb.append("availableClusterRoles:"); sb.append(availableClusterRoles + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}