package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceCAFluent<A extends ServiceCAFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ServiceCAFluent.MetadataNested<A> withNewMetadata();
  public ServiceCAFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ServiceCAFluent.MetadataNested<A> editMetadata();
  public ServiceCAFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceCAFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceCASpec getSpec();
  public ServiceCASpec buildSpec();
  public A withSpec(ServiceCASpec spec);
  public Boolean hasSpec();
  public ServiceCAFluent.SpecNested<A> withNewSpec();
  public ServiceCAFluent.SpecNested<A> withNewSpecLike(ServiceCASpec item);
  public ServiceCAFluent.SpecNested<A> editSpec();
  public ServiceCAFluent.SpecNested<A> editOrNewSpec();
  public ServiceCAFluent.SpecNested<A> editOrNewSpecLike(ServiceCASpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceCAStatus getStatus();
  public ServiceCAStatus buildStatus();
  public A withStatus(ServiceCAStatus status);
  public Boolean hasStatus();
  public ServiceCAFluent.StatusNested<A> withNewStatus();
  public ServiceCAFluent.StatusNested<A> withNewStatusLike(ServiceCAStatus item);
  public ServiceCAFluent.StatusNested<A> editStatus();
  public ServiceCAFluent.StatusNested<A> editOrNewStatus();
  public ServiceCAFluent.StatusNested<A> editOrNewStatusLike(ServiceCAStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceCAFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ServiceCASpecFluent<ServiceCAFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ServiceCAStatusFluent<ServiceCAFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}