package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCAListBuilder extends ServiceCAListFluentImpl<ServiceCAListBuilder> implements VisitableBuilder<ServiceCAList,ServiceCAListBuilder>{
  public ServiceCAListBuilder() {
    this(false);
  }
  public ServiceCAListBuilder(Boolean validationEnabled) {
    this(new ServiceCAList(), validationEnabled);
  }
  public ServiceCAListBuilder(ServiceCAListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCAListBuilder(ServiceCAListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCAList(), validationEnabled);
  }
  public ServiceCAListBuilder(ServiceCAListFluent<?> fluent,ServiceCAList instance) {
    this(fluent, instance, false);
  }
  public ServiceCAListBuilder(ServiceCAListFluent<?> fluent,ServiceCAList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceCAListBuilder(ServiceCAList instance) {
    this(instance,false);
  }
  public ServiceCAListBuilder(ServiceCAList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceCAListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCAList build() {
    ServiceCAList buildable = new ServiceCAList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}