package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCASpecBuilder extends ServiceCASpecFluentImpl<ServiceCASpecBuilder> implements VisitableBuilder<ServiceCASpec,ServiceCASpecBuilder>{
  public ServiceCASpecBuilder() {
    this(false);
  }
  public ServiceCASpecBuilder(Boolean validationEnabled) {
    this(new ServiceCASpec(), validationEnabled);
  }
  public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCASpec(), validationEnabled);
  }
  public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,ServiceCASpec instance) {
    this(fluent, instance, false);
  }
  public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,ServiceCASpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceCASpecBuilder(ServiceCASpec instance) {
    this(instance,false);
  }
  public ServiceCASpecBuilder(ServiceCASpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceCASpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCASpec build() {
    ServiceCASpec buildable = new ServiceCASpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}