package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCatalogAPIServerBuilder extends ServiceCatalogAPIServerFluentImpl<ServiceCatalogAPIServerBuilder> implements VisitableBuilder<ServiceCatalogAPIServer,ServiceCatalogAPIServerBuilder>{
  public ServiceCatalogAPIServerBuilder() {
    this(false);
  }
  public ServiceCatalogAPIServerBuilder(Boolean validationEnabled) {
    this(new ServiceCatalogAPIServer(), validationEnabled);
  }
  public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCatalogAPIServer(), validationEnabled);
  }
  public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent,ServiceCatalogAPIServer instance) {
    this(fluent, instance, false);
  }
  public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent,ServiceCatalogAPIServer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServer instance) {
    this(instance,false);
  }
  public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServer instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceCatalogAPIServerFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCatalogAPIServer build() {
    ServiceCatalogAPIServer buildable = new ServiceCatalogAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}