package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCatalogControllerManagerBuilder extends ServiceCatalogControllerManagerFluentImpl<ServiceCatalogControllerManagerBuilder> implements VisitableBuilder<ServiceCatalogControllerManager,ServiceCatalogControllerManagerBuilder>{
  public ServiceCatalogControllerManagerBuilder() {
    this(false);
  }
  public ServiceCatalogControllerManagerBuilder(Boolean validationEnabled) {
    this(new ServiceCatalogControllerManager(), validationEnabled);
  }
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCatalogControllerManager(), validationEnabled);
  }
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,ServiceCatalogControllerManager instance) {
    this(fluent, instance, false);
  }
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,ServiceCatalogControllerManager instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManager instance) {
    this(instance,false);
  }
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManager instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceCatalogControllerManagerFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCatalogControllerManager build() {
    ServiceCatalogControllerManager buildable = new ServiceCatalogControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}