package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SimpleMacvlanConfigBuilder extends SimpleMacvlanConfigFluentImpl<SimpleMacvlanConfigBuilder> implements VisitableBuilder<SimpleMacvlanConfig,SimpleMacvlanConfigBuilder>{
  public SimpleMacvlanConfigBuilder() {
    this(false);
  }
  public SimpleMacvlanConfigBuilder(Boolean validationEnabled) {
    this(new SimpleMacvlanConfig(), validationEnabled);
  }
  public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SimpleMacvlanConfig(), validationEnabled);
  }
  public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent,SimpleMacvlanConfig instance) {
    this(fluent, instance, false);
  }
  public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent,SimpleMacvlanConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withIpamConfig(instance.getIpamConfig());
      fluent.withMaster(instance.getMaster());
      fluent.withMode(instance.getMode());
      fluent.withMtu(instance.getMtu());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SimpleMacvlanConfigBuilder(SimpleMacvlanConfig instance) {
    this(instance,false);
  }
  public SimpleMacvlanConfigBuilder(SimpleMacvlanConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withIpamConfig(instance.getIpamConfig());
      this.withMaster(instance.getMaster());
      this.withMode(instance.getMode());
      this.withMtu(instance.getMtu());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SimpleMacvlanConfigFluent<?> fluent;
  Boolean validationEnabled;
  public SimpleMacvlanConfig build() {
    SimpleMacvlanConfig buildable = new SimpleMacvlanConfig(fluent.getIpamConfig(),fluent.getMaster(),fluent.getMode(),fluent.getMtu());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}