package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StaticIPAMConfigBuilder extends StaticIPAMConfigFluentImpl<StaticIPAMConfigBuilder> implements VisitableBuilder<StaticIPAMConfig,StaticIPAMConfigBuilder>{
  public StaticIPAMConfigBuilder() {
    this(false);
  }
  public StaticIPAMConfigBuilder(Boolean validationEnabled) {
    this(new StaticIPAMConfig(), validationEnabled);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StaticIPAMConfig(), validationEnabled);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance) {
    this(fluent, instance, false);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddresses(instance.getAddresses());
      fluent.withDns(instance.getDns());
      fluent.withRoutes(instance.getRoutes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfig instance) {
    this(instance,false);
  }
  public StaticIPAMConfigBuilder(StaticIPAMConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withDns(instance.getDns());
      this.withRoutes(instance.getRoutes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StaticIPAMConfigFluent<?> fluent;
  Boolean validationEnabled;
  public StaticIPAMConfig build() {
    StaticIPAMConfig buildable = new StaticIPAMConfig(fluent.getAddresses(),fluent.getDns(),fluent.getRoutes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}