package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StaticIPAMDNSBuilder extends StaticIPAMDNSFluentImpl<StaticIPAMDNSBuilder> implements VisitableBuilder<StaticIPAMDNS,StaticIPAMDNSBuilder>{
  public StaticIPAMDNSBuilder() {
    this(false);
  }
  public StaticIPAMDNSBuilder(Boolean validationEnabled) {
    this(new StaticIPAMDNS(), validationEnabled);
  }
  public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent) {
    this(fluent, false);
  }
  public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StaticIPAMDNS(), validationEnabled);
  }
  public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent,StaticIPAMDNS instance) {
    this(fluent, instance, false);
  }
  public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent,StaticIPAMDNS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDomain(instance.getDomain());
      fluent.withNameservers(instance.getNameservers());
      fluent.withSearch(instance.getSearch());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StaticIPAMDNSBuilder(StaticIPAMDNS instance) {
    this(instance,false);
  }
  public StaticIPAMDNSBuilder(StaticIPAMDNS instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDomain(instance.getDomain());
      this.withNameservers(instance.getNameservers());
      this.withSearch(instance.getSearch());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StaticIPAMDNSFluent<?> fluent;
  Boolean validationEnabled;
  public StaticIPAMDNS build() {
    StaticIPAMDNS buildable = new StaticIPAMDNS(fluent.getDomain(),fluent.getNameservers(),fluent.getSearch());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}