package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageBuilder extends StorageFluentImpl<StorageBuilder> implements VisitableBuilder<Storage,StorageBuilder>{
  public StorageBuilder() {
    this(false);
  }
  public StorageBuilder(Boolean validationEnabled) {
    this(new Storage(), validationEnabled);
  }
  public StorageBuilder(StorageFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageBuilder(StorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Storage(), validationEnabled);
  }
  public StorageBuilder(StorageFluent<?> fluent,Storage instance) {
    this(fluent, instance, false);
  }
  public StorageBuilder(StorageFluent<?> fluent,Storage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageBuilder(Storage instance) {
    this(instance,false);
  }
  public StorageBuilder(Storage instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageFluent<?> fluent;
  Boolean validationEnabled;
  public Storage build() {
    Storage buildable = new Storage(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}