package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface StorageListFluent<A extends StorageListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,Storage item);
  public A setToItems(int index,Storage item);
  public A addToItems(io.fabric8.openshift.api.model.operator.v1.Storage... items);
  public A addAllToItems(Collection<Storage> items);
  public A removeFromItems(io.fabric8.openshift.api.model.operator.v1.Storage... items);
  public A removeAllFromItems(Collection<Storage> items);
  public A removeMatchingFromItems(Predicate<StorageBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Storage> getItems();
  public List<Storage> buildItems();
  public Storage buildItem(int index);
  public Storage buildFirstItem();
  public Storage buildLastItem();
  public Storage buildMatchingItem(Predicate<StorageBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<StorageBuilder> predicate);
  public A withItems(List<Storage> items);
  public A withItems(io.fabric8.openshift.api.model.operator.v1.Storage... items);
  public Boolean hasItems();
  public StorageListFluent.ItemsNested<A> addNewItem();
  public StorageListFluent.ItemsNested<A> addNewItemLike(Storage item);
  public StorageListFluent.ItemsNested<A> setNewItemLike(int index,Storage item);
  public StorageListFluent.ItemsNested<A> editItem(int index);
  public StorageListFluent.ItemsNested<A> editFirstItem();
  public StorageListFluent.ItemsNested<A> editLastItem();
  public StorageListFluent.ItemsNested<A> editMatchingItem(Predicate<StorageBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,StorageFluent<StorageListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}