package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SyslogLoggingDestinationParametersBuilder extends SyslogLoggingDestinationParametersFluentImpl<SyslogLoggingDestinationParametersBuilder> implements VisitableBuilder<SyslogLoggingDestinationParameters,SyslogLoggingDestinationParametersBuilder>{
  public SyslogLoggingDestinationParametersBuilder() {
    this(false);
  }
  public SyslogLoggingDestinationParametersBuilder(Boolean validationEnabled) {
    this(new SyslogLoggingDestinationParameters(), validationEnabled);
  }
  public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SyslogLoggingDestinationParameters(), validationEnabled);
  }
  public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent,SyslogLoggingDestinationParameters instance) {
    this(fluent, instance, false);
  }
  public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent,SyslogLoggingDestinationParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withFacility(instance.getFacility());
      fluent.withMaxLength(instance.getMaxLength());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParameters instance) {
    this(instance,false);
  }
  public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withFacility(instance.getFacility());
      this.withMaxLength(instance.getMaxLength());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SyslogLoggingDestinationParametersFluent<?> fluent;
  Boolean validationEnabled;
  public SyslogLoggingDestinationParameters build() {
    SyslogLoggingDestinationParameters buildable = new SyslogLoggingDestinationParameters(fluent.getAddress(),fluent.getFacility(),fluent.getMaxLength(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}