package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpstreamResolversBuilder extends UpstreamResolversFluentImpl<UpstreamResolversBuilder> implements VisitableBuilder<UpstreamResolvers,UpstreamResolversBuilder>{
  public UpstreamResolversBuilder() {
    this(false);
  }
  public UpstreamResolversBuilder(Boolean validationEnabled) {
    this(new UpstreamResolvers(), validationEnabled);
  }
  public UpstreamResolversBuilder(UpstreamResolversFluent<?> fluent) {
    this(fluent, false);
  }
  public UpstreamResolversBuilder(UpstreamResolversFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UpstreamResolvers(), validationEnabled);
  }
  public UpstreamResolversBuilder(UpstreamResolversFluent<?> fluent,UpstreamResolvers instance) {
    this(fluent, instance, false);
  }
  public UpstreamResolversBuilder(UpstreamResolversFluent<?> fluent,UpstreamResolvers instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPolicy(instance.getPolicy());
      fluent.withUpstreams(instance.getUpstreams());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UpstreamResolversBuilder(UpstreamResolvers instance) {
    this(instance,false);
  }
  public UpstreamResolversBuilder(UpstreamResolvers instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPolicy(instance.getPolicy());
      this.withUpstreams(instance.getUpstreams());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  UpstreamResolversFluent<?> fluent;
  Boolean validationEnabled;
  public UpstreamResolvers build() {
    UpstreamResolvers buildable = new UpstreamResolvers(fluent.getPolicy(),fluent.getUpstreams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}