package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UpstreamResolversFluentImpl<A extends UpstreamResolversFluent<A>> extends BaseFluent<A> implements UpstreamResolversFluent<A>{
  public UpstreamResolversFluentImpl() {
  }
  public UpstreamResolversFluentImpl(UpstreamResolvers instance) {
    if (instance != null) {
      this.withPolicy(instance.getPolicy());
      this.withUpstreams(instance.getUpstreams());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String policy;
  private ArrayList<UpstreamBuilder> upstreams = new ArrayList<UpstreamBuilder>();
  private Map<String,Object> additionalProperties;
  public String getPolicy() {
    return this.policy;
  }
  public A withPolicy(String policy) {
    this.policy=policy; return (A) this;
  }
  public Boolean hasPolicy() {
    return this.policy != null;
  }
  public A addToUpstreams(int index,Upstream item) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<UpstreamBuilder>();}
    UpstreamBuilder builder = new UpstreamBuilder(item);
    if (index < 0 || index >= upstreams.size()) { _visitables.get("upstreams").add(builder); upstreams.add(builder); } else { _visitables.get("upstreams").add(index, builder); upstreams.add(index, builder);}
    return (A)this;
  }
  public A setToUpstreams(int index,Upstream item) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<UpstreamBuilder>();}
    UpstreamBuilder builder = new UpstreamBuilder(item);
    if (index < 0 || index >= upstreams.size()) { _visitables.get("upstreams").add(builder); upstreams.add(builder); } else { _visitables.get("upstreams").set(index, builder); upstreams.set(index, builder);}
    return (A)this;
  }
  public A addToUpstreams(io.fabric8.openshift.api.model.operator.v1.Upstream... items) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<UpstreamBuilder>();}
    for (Upstream item : items) {UpstreamBuilder builder = new UpstreamBuilder(item);_visitables.get("upstreams").add(builder);this.upstreams.add(builder);} return (A)this;
  }
  public A addAllToUpstreams(Collection<Upstream> items) {
    if (this.upstreams == null) {this.upstreams = new ArrayList<UpstreamBuilder>();}
    for (Upstream item : items) {UpstreamBuilder builder = new UpstreamBuilder(item);_visitables.get("upstreams").add(builder);this.upstreams.add(builder);} return (A)this;
  }
  public A removeFromUpstreams(io.fabric8.openshift.api.model.operator.v1.Upstream... items) {
    for (Upstream item : items) {UpstreamBuilder builder = new UpstreamBuilder(item);_visitables.get("upstreams").remove(builder);if (this.upstreams != null) {this.upstreams.remove(builder);}} return (A)this;
  }
  public A removeAllFromUpstreams(Collection<Upstream> items) {
    for (Upstream item : items) {UpstreamBuilder builder = new UpstreamBuilder(item);_visitables.get("upstreams").remove(builder);if (this.upstreams != null) {this.upstreams.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUpstreams(Predicate<UpstreamBuilder> predicate) {
    if (upstreams == null) return (A) this;
    final Iterator<UpstreamBuilder> each = upstreams.iterator();
    final List visitables = _visitables.get("upstreams");
    while (each.hasNext()) {
      UpstreamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildUpstreams instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Upstream> getUpstreams() {
    return upstreams != null ? build(upstreams) : null;
  }
  public List<Upstream> buildUpstreams() {
    return upstreams != null ? build(upstreams) : null;
  }
  public Upstream buildUpstream(int index) {
    return this.upstreams.get(index).build();
  }
  public Upstream buildFirstUpstream() {
    return this.upstreams.get(0).build();
  }
  public Upstream buildLastUpstream() {
    return this.upstreams.get(upstreams.size() - 1).build();
  }
  public Upstream buildMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
    for (UpstreamBuilder item: upstreams) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
    for (UpstreamBuilder item: upstreams) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUpstreams(List<Upstream> upstreams) {
    if (this.upstreams != null) { _visitables.get("upstreams").clear();}
    if (upstreams != null) {this.upstreams = new ArrayList(); for (Upstream item : upstreams){this.addToUpstreams(item);}} else { this.upstreams = null;} return (A) this;
  }
  public A withUpstreams(io.fabric8.openshift.api.model.operator.v1.Upstream... upstreams) {
    if (this.upstreams != null) {this.upstreams.clear(); _visitables.remove("upstreams"); }
    if (upstreams != null) {for (Upstream item :upstreams){ this.addToUpstreams(item);}} return (A) this;
  }
  public Boolean hasUpstreams() {
    return upstreams != null && !upstreams.isEmpty();
  }
  public A addNewUpstream(String address,Integer port,String type) {
    return (A)addToUpstreams(new Upstream(address, port, type));
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> addNewUpstream() {
    return new UpstreamResolversFluentImpl.UpstreamsNestedImpl();
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> addNewUpstreamLike(Upstream item) {
    return new UpstreamResolversFluentImpl.UpstreamsNestedImpl(-1, item);
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> setNewUpstreamLike(int index,Upstream item) {
    return new UpstreamResolversFluentImpl.UpstreamsNestedImpl(index, item);
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> editUpstream(int index) {
    if (upstreams.size() <= index) throw new RuntimeException("Can't edit upstreams. Index exceeds size.");
    return setNewUpstreamLike(index, buildUpstream(index));
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> editFirstUpstream() {
    if (upstreams.size() == 0) throw new RuntimeException("Can't edit first upstreams. The list is empty.");
    return setNewUpstreamLike(0, buildUpstream(0));
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> editLastUpstream() {
    int index = upstreams.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last upstreams. The list is empty.");
    return setNewUpstreamLike(index, buildUpstream(index));
  }
  public UpstreamResolversFluentImpl.UpstreamsNested<A> editMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<upstreams.size();i++) { 
    if (predicate.test(upstreams.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching upstreams. No match found.");
    return setNewUpstreamLike(index, buildUpstream(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    UpstreamResolversFluentImpl that = (UpstreamResolversFluentImpl) o;
    if (!java.util.Objects.equals(policy, that.policy)) return false;

    if (!java.util.Objects.equals(upstreams, that.upstreams)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(policy,  upstreams,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (policy != null) { sb.append("policy:"); sb.append(policy + ","); }
    if (upstreams != null && !upstreams.isEmpty()) { sb.append("upstreams:"); sb.append(upstreams + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class UpstreamsNestedImpl<N> extends UpstreamFluentImpl<UpstreamResolversFluentImpl.UpstreamsNested<N>> implements UpstreamResolversFluentImpl.UpstreamsNested<N>,Nested<N>{
    UpstreamsNestedImpl(int index,Upstream item) {
      this.index = index;
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamsNestedImpl() {
      this.index = -1;
      this.builder = new UpstreamBuilder(this);
    }
    UpstreamBuilder builder;
    int index;
    public N and() {
      return (N) UpstreamResolversFluentImpl.this.setToUpstreams(index,builder.build());
    }
    public N endUpstream() {
      return and();
    }
    
  }
  
}