/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.AdditionalRoutingCapabilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AdditionalRoutingCapabilitiesFluent<A extends AdditionalRoutingCapabilitiesFluent<A>>
extends BaseFluent<A> {
    private List<String> providers = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public AdditionalRoutingCapabilitiesFluent() {
    }

    public AdditionalRoutingCapabilitiesFluent(AdditionalRoutingCapabilities instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdditionalRoutingCapabilities instance) {
        AdditionalRoutingCapabilities additionalRoutingCapabilities = instance = instance != null ? instance : new AdditionalRoutingCapabilities();
        if (instance != null) {
            this.withProviders(instance.getProviders());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToProviders(int index, String item) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        this.providers.add(index, item);
        return (A)((Object)this);
    }

    public A setToProviders(int index, String item) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        this.providers.set(index, item);
        return (A)((Object)this);
    }

    public A addToProviders(String ... items) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        for (String item : items) {
            this.providers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToProviders(Collection<String> items) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        for (String item : items) {
            this.providers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromProviders(String ... items) {
        if (this.providers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.providers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProviders(Collection<String> items) {
        if (this.providers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.providers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public String getProvider(int index) {
        return this.providers.get(index);
    }

    public String getFirstProvider() {
        return this.providers.get(0);
    }

    public String getLastProvider() {
        return this.providers.get(this.providers.size() - 1);
    }

    public String getMatchingProvider(Predicate<String> predicate) {
        for (String item : this.providers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingProvider(Predicate<String> predicate) {
        for (String item : this.providers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProviders(List<String> providers) {
        if (providers != null) {
            this.providers = new ArrayList<String>();
            for (String item : providers) {
                this.addToProviders(item);
            }
        } else {
            this.providers = null;
        }
        return (A)((Object)this);
    }

    public A withProviders(String ... providers) {
        if (this.providers != null) {
            this.providers.clear();
            this._visitables.remove((Object)"providers");
        }
        if (providers != null) {
            for (String item : providers) {
                this.addToProviders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProviders() {
        return this.providers != null && !this.providers.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdditionalRoutingCapabilitiesFluent that = (AdditionalRoutingCapabilitiesFluent)((Object)o);
        if (!Objects.equals(this.providers, that.providers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.providers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.providers != null && !this.providers.isEmpty()) {
            sb.append("providers:");
            sb.append(this.providers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

