package io.fabric8.openshift.api.model.operator.network.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressRouterAddressBuilder extends EgressRouterAddressFluent<EgressRouterAddressBuilder> implements VisitableBuilder<EgressRouterAddress,EgressRouterAddressBuilder>{
  public EgressRouterAddressBuilder() {
    this(new EgressRouterAddress());
  }
  
  public EgressRouterAddressBuilder(EgressRouterAddressFluent<?> fluent) {
    this(fluent, new EgressRouterAddress());
  }
  
  public EgressRouterAddressBuilder(EgressRouterAddressFluent<?> fluent,EgressRouterAddress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressRouterAddressBuilder(EgressRouterAddress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressRouterAddressFluent<?> fluent;
  
  public EgressRouterAddress build() {
    EgressRouterAddress buildable = new EgressRouterAddress(fluent.getGateway(),fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}