package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CloudCredentialBuilder extends CloudCredentialFluent<CloudCredentialBuilder> implements VisitableBuilder<CloudCredential,CloudCredentialBuilder>{
  public CloudCredentialBuilder() {
    this(new CloudCredential());
  }
  
  public CloudCredentialBuilder(CloudCredentialFluent<?> fluent) {
    this(fluent, new CloudCredential());
  }
  
  public CloudCredentialBuilder(CloudCredentialFluent<?> fluent,CloudCredential instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CloudCredentialBuilder(CloudCredential instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CloudCredentialFluent<?> fluent;
  
  public CloudCredential build() {
    CloudCredential buildable = new CloudCredential(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}