package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DNSTransportConfigFluent<A extends DNSTransportConfigFluent<A>> extends BaseFluent<A>{
  public DNSTransportConfigFluent() {
  }
  
  public DNSTransportConfigFluent(DNSTransportConfig instance) {
    this.copyInstance(instance);
  }
  private DNSOverTLSConfigBuilder tls;
  private String transport;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DNSTransportConfig instance) {
    instance = (instance != null ? instance : new DNSTransportConfig());
    if (instance != null) {
          this.withTls(instance.getTls());
          this.withTransport(instance.getTransport());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public DNSOverTLSConfig buildTls() {
    return this.tls != null ? this.tls.build() : null;
  }
  
  public A withTls(DNSOverTLSConfig tls) {
    this._visitables.remove("tls");
    if (tls != null) {
        this.tls = new DNSOverTLSConfigBuilder(tls);
        this._visitables.get("tls").add(this.tls);
    } else {
        this.tls = null;
        this._visitables.get("tls").remove(this.tls);
    }
    return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(DNSOverTLSConfig item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new DNSOverTLSConfigBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(DNSOverTLSConfig item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public String getTransport() {
    return this.transport;
  }
  
  public A withTransport(String transport) {
    this.transport = transport;
    return (A) this;
  }
  
  public boolean hasTransport() {
    return this.transport != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSTransportConfigFluent that = (DNSTransportConfigFluent) o;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    if (!java.util.Objects.equals(transport, that.transport)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(tls,  transport,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (transport != null) { sb.append("transport:"); sb.append(transport + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TlsNested<N> extends DNSOverTLSConfigFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(DNSOverTLSConfig item) {
      this.builder = new DNSOverTLSConfigBuilder(this, item);
    }
    DNSOverTLSConfigBuilder builder;
    
    public N and() {
      return (N) DNSTransportConfigFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}