package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ManagedBootImagesFluent<A extends ManagedBootImagesFluent<A>> extends BaseFluent<A>{
  public ManagedBootImagesFluent() {
  }
  
  public ManagedBootImagesFluent(ManagedBootImages instance) {
    this.copyInstance(instance);
  }
  private ArrayList<MachineManagerBuilder> machineManagers = new ArrayList<MachineManagerBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ManagedBootImages instance) {
    instance = (instance != null ? instance : new ManagedBootImages());
    if (instance != null) {
          this.withMachineManagers(instance.getMachineManagers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToMachineManagers(int index,MachineManager item) {
    if (this.machineManagers == null) {this.machineManagers = new ArrayList<MachineManagerBuilder>();}
    MachineManagerBuilder builder = new MachineManagerBuilder(item);
    if (index < 0 || index >= machineManagers.size()) { _visitables.get("machineManagers").add(builder); machineManagers.add(builder); } else { _visitables.get("machineManagers").add(index, builder); machineManagers.add(index, builder);}
    return (A)this;
  }
  
  public A setToMachineManagers(int index,MachineManager item) {
    if (this.machineManagers == null) {this.machineManagers = new ArrayList<MachineManagerBuilder>();}
    MachineManagerBuilder builder = new MachineManagerBuilder(item);
    if (index < 0 || index >= machineManagers.size()) { _visitables.get("machineManagers").add(builder); machineManagers.add(builder); } else { _visitables.get("machineManagers").set(index, builder); machineManagers.set(index, builder);}
    return (A)this;
  }
  
  public A addToMachineManagers(io.fabric8.openshift.api.model.operator.v1.MachineManager... items) {
    if (this.machineManagers == null) {this.machineManagers = new ArrayList<MachineManagerBuilder>();}
    for (MachineManager item : items) {MachineManagerBuilder builder = new MachineManagerBuilder(item);_visitables.get("machineManagers").add(builder);this.machineManagers.add(builder);} return (A)this;
  }
  
  public A addAllToMachineManagers(Collection<MachineManager> items) {
    if (this.machineManagers == null) {this.machineManagers = new ArrayList<MachineManagerBuilder>();}
    for (MachineManager item : items) {MachineManagerBuilder builder = new MachineManagerBuilder(item);_visitables.get("machineManagers").add(builder);this.machineManagers.add(builder);} return (A)this;
  }
  
  public A removeFromMachineManagers(io.fabric8.openshift.api.model.operator.v1.MachineManager... items) {
    if (this.machineManagers == null) return (A)this;
    for (MachineManager item : items) {MachineManagerBuilder builder = new MachineManagerBuilder(item);_visitables.get("machineManagers").remove(builder); this.machineManagers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMachineManagers(Collection<MachineManager> items) {
    if (this.machineManagers == null) return (A)this;
    for (MachineManager item : items) {MachineManagerBuilder builder = new MachineManagerBuilder(item);_visitables.get("machineManagers").remove(builder); this.machineManagers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMachineManagers(Predicate<MachineManagerBuilder> predicate) {
    if (machineManagers == null) return (A) this;
    final Iterator<MachineManagerBuilder> each = machineManagers.iterator();
    final List visitables = _visitables.get("machineManagers");
    while (each.hasNext()) {
      MachineManagerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineManager> buildMachineManagers() {
    return this.machineManagers != null ? build(machineManagers) : null;
  }
  
  public MachineManager buildMachineManager(int index) {
    return this.machineManagers.get(index).build();
  }
  
  public MachineManager buildFirstMachineManager() {
    return this.machineManagers.get(0).build();
  }
  
  public MachineManager buildLastMachineManager() {
    return this.machineManagers.get(machineManagers.size() - 1).build();
  }
  
  public MachineManager buildMatchingMachineManager(Predicate<MachineManagerBuilder> predicate) {
      for (MachineManagerBuilder item : machineManagers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMachineManager(Predicate<MachineManagerBuilder> predicate) {
      for (MachineManagerBuilder item : machineManagers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMachineManagers(List<MachineManager> machineManagers) {
    if (this.machineManagers != null) {
      this._visitables.get("machineManagers").clear();
    }
    if (machineManagers != null) {
        this.machineManagers = new ArrayList();
        for (MachineManager item : machineManagers) {
          this.addToMachineManagers(item);
        }
    } else {
      this.machineManagers = null;
    }
    return (A) this;
  }
  
  public A withMachineManagers(io.fabric8.openshift.api.model.operator.v1.MachineManager... machineManagers) {
    if (this.machineManagers != null) {
        this.machineManagers.clear();
        _visitables.remove("machineManagers");
    }
    if (machineManagers != null) {
      for (MachineManager item : machineManagers) {
        this.addToMachineManagers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMachineManagers() {
    return this.machineManagers != null && !this.machineManagers.isEmpty();
  }
  
  public MachineManagersNested<A> addNewMachineManager() {
    return new MachineManagersNested(-1, null);
  }
  
  public MachineManagersNested<A> addNewMachineManagerLike(MachineManager item) {
    return new MachineManagersNested(-1, item);
  }
  
  public MachineManagersNested<A> setNewMachineManagerLike(int index,MachineManager item) {
    return new MachineManagersNested(index, item);
  }
  
  public MachineManagersNested<A> editMachineManager(int index) {
    if (machineManagers.size() <= index) throw new RuntimeException("Can't edit machineManagers. Index exceeds size.");
    return setNewMachineManagerLike(index, buildMachineManager(index));
  }
  
  public MachineManagersNested<A> editFirstMachineManager() {
    if (machineManagers.size() == 0) throw new RuntimeException("Can't edit first machineManagers. The list is empty.");
    return setNewMachineManagerLike(0, buildMachineManager(0));
  }
  
  public MachineManagersNested<A> editLastMachineManager() {
    int index = machineManagers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last machineManagers. The list is empty.");
    return setNewMachineManagerLike(index, buildMachineManager(index));
  }
  
  public MachineManagersNested<A> editMatchingMachineManager(Predicate<MachineManagerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<machineManagers.size();i++) { 
    if (predicate.test(machineManagers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching machineManagers. No match found.");
    return setNewMachineManagerLike(index, buildMachineManager(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ManagedBootImagesFluent that = (ManagedBootImagesFluent) o;
    if (!java.util.Objects.equals(machineManagers, that.machineManagers)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(machineManagers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (machineManagers != null && !machineManagers.isEmpty()) { sb.append("machineManagers:"); sb.append(machineManagers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MachineManagersNested<N> extends MachineManagerFluent<MachineManagersNested<N>> implements Nested<N>{
    MachineManagersNested(int index,MachineManager item) {
      this.index = index;
      this.builder = new MachineManagerBuilder(this, item);
    }
    MachineManagerBuilder builder;
    int index;
    
    public N and() {
      return (N) ManagedBootImagesFluent.this.setToMachineManagers(index,builder.build());
    }
    
    public N endMachineManager() {
      return and();
    }
    
  
  }

}