package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StaticPodOperatorStatusFluent<A extends StaticPodOperatorStatusFluent<A>> extends BaseFluent<A>{
  public StaticPodOperatorStatusFluent() {
  }
  
  public StaticPodOperatorStatusFluent(StaticPodOperatorStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();
  private VersionAvailabilityBuilder currentVersionAvailability;
  private Integer latestAvailableDeploymentGeneration;
  private ArrayList<NodeStatusBuilder> nodeStatuses = new ArrayList<NodeStatusBuilder>();
  private Long observedGeneration;
  private String state;
  private VersionAvailabilityBuilder targetVersionAvailability;
  private String taskSummary;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StaticPodOperatorStatus instance) {
    instance = (instance != null ? instance : new StaticPodOperatorStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withCurrentVersionAvailability(instance.getCurrentVersionAvailability());
          this.withLatestAvailableDeploymentGeneration(instance.getLatestAvailableDeploymentGeneration());
          this.withNodeStatuses(instance.getNodeStatuses());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withState(instance.getState());
          this.withTargetVersionAvailability(instance.getTargetVersionAvailability());
          this.withTaskSummary(instance.getTaskSummary());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1alpha1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1alpha1.OperatorCondition... items) {
    if (this.conditions == null) return (A)this;
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) return (A)this;
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<OperatorConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      OperatorConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<OperatorCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public OperatorCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public OperatorCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public OperatorCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
      for (OperatorConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
      for (OperatorConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<OperatorCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (OperatorCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.operator.v1alpha1.OperatorCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (OperatorCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public VersionAvailability buildCurrentVersionAvailability() {
    return this.currentVersionAvailability != null ? this.currentVersionAvailability.build() : null;
  }
  
  public A withCurrentVersionAvailability(VersionAvailability currentVersionAvailability) {
    this._visitables.remove("currentVersionAvailability");
    if (currentVersionAvailability != null) {
        this.currentVersionAvailability = new VersionAvailabilityBuilder(currentVersionAvailability);
        this._visitables.get("currentVersionAvailability").add(this.currentVersionAvailability);
    } else {
        this.currentVersionAvailability = null;
        this._visitables.get("currentVersionAvailability").remove(this.currentVersionAvailability);
    }
    return (A) this;
  }
  
  public boolean hasCurrentVersionAvailability() {
    return this.currentVersionAvailability != null;
  }
  
  public CurrentVersionAvailabilityNested<A> withNewCurrentVersionAvailability() {
    return new CurrentVersionAvailabilityNested(null);
  }
  
  public CurrentVersionAvailabilityNested<A> withNewCurrentVersionAvailabilityLike(VersionAvailability item) {
    return new CurrentVersionAvailabilityNested(item);
  }
  
  public CurrentVersionAvailabilityNested<A> editCurrentVersionAvailability() {
    return withNewCurrentVersionAvailabilityLike(java.util.Optional.ofNullable(buildCurrentVersionAvailability()).orElse(null));
  }
  
  public CurrentVersionAvailabilityNested<A> editOrNewCurrentVersionAvailability() {
    return withNewCurrentVersionAvailabilityLike(java.util.Optional.ofNullable(buildCurrentVersionAvailability()).orElse(new VersionAvailabilityBuilder().build()));
  }
  
  public CurrentVersionAvailabilityNested<A> editOrNewCurrentVersionAvailabilityLike(VersionAvailability item) {
    return withNewCurrentVersionAvailabilityLike(java.util.Optional.ofNullable(buildCurrentVersionAvailability()).orElse(item));
  }
  
  public Integer getLatestAvailableDeploymentGeneration() {
    return this.latestAvailableDeploymentGeneration;
  }
  
  public A withLatestAvailableDeploymentGeneration(Integer latestAvailableDeploymentGeneration) {
    this.latestAvailableDeploymentGeneration = latestAvailableDeploymentGeneration;
    return (A) this;
  }
  
  public boolean hasLatestAvailableDeploymentGeneration() {
    return this.latestAvailableDeploymentGeneration != null;
  }
  
  public A addToNodeStatuses(int index,NodeStatus item) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    NodeStatusBuilder builder = new NodeStatusBuilder(item);
    if (index < 0 || index >= nodeStatuses.size()) { _visitables.get("nodeStatuses").add(builder); nodeStatuses.add(builder); } else { _visitables.get("nodeStatuses").add(index, builder); nodeStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToNodeStatuses(int index,NodeStatus item) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    NodeStatusBuilder builder = new NodeStatusBuilder(item);
    if (index < 0 || index >= nodeStatuses.size()) { _visitables.get("nodeStatuses").add(builder); nodeStatuses.add(builder); } else { _visitables.get("nodeStatuses").set(index, builder); nodeStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToNodeStatuses(io.fabric8.openshift.api.model.operator.v1alpha1.NodeStatus... items) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").add(builder);this.nodeStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToNodeStatuses(Collection<NodeStatus> items) {
    if (this.nodeStatuses == null) {this.nodeStatuses = new ArrayList<NodeStatusBuilder>();}
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").add(builder);this.nodeStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromNodeStatuses(io.fabric8.openshift.api.model.operator.v1alpha1.NodeStatus... items) {
    if (this.nodeStatuses == null) return (A)this;
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").remove(builder); this.nodeStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromNodeStatuses(Collection<NodeStatus> items) {
    if (this.nodeStatuses == null) return (A)this;
    for (NodeStatus item : items) {NodeStatusBuilder builder = new NodeStatusBuilder(item);_visitables.get("nodeStatuses").remove(builder); this.nodeStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromNodeStatuses(Predicate<NodeStatusBuilder> predicate) {
    if (nodeStatuses == null) return (A) this;
    final Iterator<NodeStatusBuilder> each = nodeStatuses.iterator();
    final List visitables = _visitables.get("nodeStatuses");
    while (each.hasNext()) {
      NodeStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NodeStatus> buildNodeStatuses() {
    return this.nodeStatuses != null ? build(nodeStatuses) : null;
  }
  
  public NodeStatus buildNodeStatus(int index) {
    return this.nodeStatuses.get(index).build();
  }
  
  public NodeStatus buildFirstNodeStatus() {
    return this.nodeStatuses.get(0).build();
  }
  
  public NodeStatus buildLastNodeStatus() {
    return this.nodeStatuses.get(nodeStatuses.size() - 1).build();
  }
  
  public NodeStatus buildMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate) {
      for (NodeStatusBuilder item : nodeStatuses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate) {
      for (NodeStatusBuilder item : nodeStatuses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNodeStatuses(List<NodeStatus> nodeStatuses) {
    if (this.nodeStatuses != null) {
      this._visitables.get("nodeStatuses").clear();
    }
    if (nodeStatuses != null) {
        this.nodeStatuses = new ArrayList();
        for (NodeStatus item : nodeStatuses) {
          this.addToNodeStatuses(item);
        }
    } else {
      this.nodeStatuses = null;
    }
    return (A) this;
  }
  
  public A withNodeStatuses(io.fabric8.openshift.api.model.operator.v1alpha1.NodeStatus... nodeStatuses) {
    if (this.nodeStatuses != null) {
        this.nodeStatuses.clear();
        _visitables.remove("nodeStatuses");
    }
    if (nodeStatuses != null) {
      for (NodeStatus item : nodeStatuses) {
        this.addToNodeStatuses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNodeStatuses() {
    return this.nodeStatuses != null && !this.nodeStatuses.isEmpty();
  }
  
  public NodeStatusesNested<A> addNewNodeStatus() {
    return new NodeStatusesNested(-1, null);
  }
  
  public NodeStatusesNested<A> addNewNodeStatusLike(NodeStatus item) {
    return new NodeStatusesNested(-1, item);
  }
  
  public NodeStatusesNested<A> setNewNodeStatusLike(int index,NodeStatus item) {
    return new NodeStatusesNested(index, item);
  }
  
  public NodeStatusesNested<A> editNodeStatus(int index) {
    if (nodeStatuses.size() <= index) throw new RuntimeException("Can't edit nodeStatuses. Index exceeds size.");
    return setNewNodeStatusLike(index, buildNodeStatus(index));
  }
  
  public NodeStatusesNested<A> editFirstNodeStatus() {
    if (nodeStatuses.size() == 0) throw new RuntimeException("Can't edit first nodeStatuses. The list is empty.");
    return setNewNodeStatusLike(0, buildNodeStatus(0));
  }
  
  public NodeStatusesNested<A> editLastNodeStatus() {
    int index = nodeStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nodeStatuses. The list is empty.");
    return setNewNodeStatusLike(index, buildNodeStatus(index));
  }
  
  public NodeStatusesNested<A> editMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nodeStatuses.size();i++) { 
    if (predicate.test(nodeStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nodeStatuses. No match found.");
    return setNewNodeStatusLike(index, buildNodeStatus(index));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public VersionAvailability buildTargetVersionAvailability() {
    return this.targetVersionAvailability != null ? this.targetVersionAvailability.build() : null;
  }
  
  public A withTargetVersionAvailability(VersionAvailability targetVersionAvailability) {
    this._visitables.remove("targetVersionAvailability");
    if (targetVersionAvailability != null) {
        this.targetVersionAvailability = new VersionAvailabilityBuilder(targetVersionAvailability);
        this._visitables.get("targetVersionAvailability").add(this.targetVersionAvailability);
    } else {
        this.targetVersionAvailability = null;
        this._visitables.get("targetVersionAvailability").remove(this.targetVersionAvailability);
    }
    return (A) this;
  }
  
  public boolean hasTargetVersionAvailability() {
    return this.targetVersionAvailability != null;
  }
  
  public TargetVersionAvailabilityNested<A> withNewTargetVersionAvailability() {
    return new TargetVersionAvailabilityNested(null);
  }
  
  public TargetVersionAvailabilityNested<A> withNewTargetVersionAvailabilityLike(VersionAvailability item) {
    return new TargetVersionAvailabilityNested(item);
  }
  
  public TargetVersionAvailabilityNested<A> editTargetVersionAvailability() {
    return withNewTargetVersionAvailabilityLike(java.util.Optional.ofNullable(buildTargetVersionAvailability()).orElse(null));
  }
  
  public TargetVersionAvailabilityNested<A> editOrNewTargetVersionAvailability() {
    return withNewTargetVersionAvailabilityLike(java.util.Optional.ofNullable(buildTargetVersionAvailability()).orElse(new VersionAvailabilityBuilder().build()));
  }
  
  public TargetVersionAvailabilityNested<A> editOrNewTargetVersionAvailabilityLike(VersionAvailability item) {
    return withNewTargetVersionAvailabilityLike(java.util.Optional.ofNullable(buildTargetVersionAvailability()).orElse(item));
  }
  
  public String getTaskSummary() {
    return this.taskSummary;
  }
  
  public A withTaskSummary(String taskSummary) {
    this.taskSummary = taskSummary;
    return (A) this;
  }
  
  public boolean hasTaskSummary() {
    return this.taskSummary != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StaticPodOperatorStatusFluent that = (StaticPodOperatorStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(currentVersionAvailability, that.currentVersionAvailability)) return false;
    if (!java.util.Objects.equals(latestAvailableDeploymentGeneration, that.latestAvailableDeploymentGeneration)) return false;
    if (!java.util.Objects.equals(nodeStatuses, that.nodeStatuses)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(targetVersionAvailability, that.targetVersionAvailability)) return false;
    if (!java.util.Objects.equals(taskSummary, that.taskSummary)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  currentVersionAvailability,  latestAvailableDeploymentGeneration,  nodeStatuses,  observedGeneration,  state,  targetVersionAvailability,  taskSummary,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentVersionAvailability != null) { sb.append("currentVersionAvailability:"); sb.append(currentVersionAvailability + ","); }
    if (latestAvailableDeploymentGeneration != null) { sb.append("latestAvailableDeploymentGeneration:"); sb.append(latestAvailableDeploymentGeneration + ","); }
    if (nodeStatuses != null && !nodeStatuses.isEmpty()) { sb.append("nodeStatuses:"); sb.append(nodeStatuses + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (targetVersionAvailability != null) { sb.append("targetVersionAvailability:"); sb.append(targetVersionAvailability + ","); }
    if (taskSummary != null) { sb.append("taskSummary:"); sb.append(taskSummary + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends OperatorConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,OperatorCondition item) {
      this.index = index;
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) StaticPodOperatorStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class CurrentVersionAvailabilityNested<N> extends VersionAvailabilityFluent<CurrentVersionAvailabilityNested<N>> implements Nested<N>{
    CurrentVersionAvailabilityNested(VersionAvailability item) {
      this.builder = new VersionAvailabilityBuilder(this, item);
    }
    VersionAvailabilityBuilder builder;
    
    public N and() {
      return (N) StaticPodOperatorStatusFluent.this.withCurrentVersionAvailability(builder.build());
    }
    
    public N endCurrentVersionAvailability() {
      return and();
    }
    
  
  }
  public class NodeStatusesNested<N> extends NodeStatusFluent<NodeStatusesNested<N>> implements Nested<N>{
    NodeStatusesNested(int index,NodeStatus item) {
      this.index = index;
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) StaticPodOperatorStatusFluent.this.setToNodeStatuses(index,builder.build());
    }
    
    public N endNodeStatus() {
      return and();
    }
    
  
  }
  public class TargetVersionAvailabilityNested<N> extends VersionAvailabilityFluent<TargetVersionAvailabilityNested<N>> implements Nested<N>{
    TargetVersionAvailabilityNested(VersionAvailability item) {
      this.builder = new VersionAvailabilityBuilder(this, item);
    }
    VersionAvailabilityBuilder builder;
    
    public N and() {
      return (N) StaticPodOperatorStatusFluent.this.withTargetVersionAvailability(builder.build());
    }
    
    public N endTargetVersionAvailability() {
      return and();
    }
    
  
  }

}