package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigurationSpecBuilder extends MachineConfigurationSpecFluent<MachineConfigurationSpecBuilder> implements VisitableBuilder<MachineConfigurationSpec,MachineConfigurationSpecBuilder>{
  public MachineConfigurationSpecBuilder() {
    this(new MachineConfigurationSpec());
  }
  
  public MachineConfigurationSpecBuilder(MachineConfigurationSpecFluent<?> fluent) {
    this(fluent, new MachineConfigurationSpec());
  }
  
  public MachineConfigurationSpecBuilder(MachineConfigurationSpecFluent<?> fluent,MachineConfigurationSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigurationSpecBuilder(MachineConfigurationSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigurationSpecFluent<?> fluent;
  
  public MachineConfigurationSpec build() {
    MachineConfigurationSpec buildable = new MachineConfigurationSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.buildManagedBootImages(),fluent.getManagementState(),fluent.buildNodeDisruptionPolicy(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}