package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OLMListBuilder extends OLMListFluent<OLMListBuilder> implements VisitableBuilder<OLMList,OLMListBuilder>{
  public OLMListBuilder() {
    this(new OLMList());
  }
  
  public OLMListBuilder(OLMListFluent<?> fluent) {
    this(fluent, new OLMList());
  }
  
  public OLMListBuilder(OLMListFluent<?> fluent,OLMList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OLMListBuilder(OLMList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OLMListFluent<?> fluent;
  
  public OLMList build() {
    OLMList buildable = new OLMList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}