/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.FileReferenceSource;
import io.fabric8.openshift.api.model.operator.v1.FileReferenceSourceBuilder;
import io.fabric8.openshift.api.model.operator.v1.FileReferenceSourceFluent;
import io.fabric8.openshift.api.model.operator.v1.Theme;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ThemeFluent<A extends ThemeFluent<A>>
extends BaseFluent<A> {
    private String mode;
    private FileReferenceSourceBuilder source;
    private Map<String, Object> additionalProperties;

    public ThemeFluent() {
    }

    public ThemeFluent(Theme instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Theme instance) {
        Theme theme = instance = instance != null ? instance : new Theme();
        if (instance != null) {
            this.withMode(instance.getMode());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public FileReferenceSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(FileReferenceSource source) {
        this._visitables.remove((Object)"source");
        if (source != null) {
            this.source = new FileReferenceSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(FileReferenceSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new FileReferenceSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(FileReferenceSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThemeFluent that = (ThemeFluent)((Object)o);
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.source, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(String.valueOf((Object)this.source) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceNested<N>
    extends FileReferenceSourceFluent<SourceNested<N>>
    implements Nested<N> {
        FileReferenceSourceBuilder builder;

        SourceNested(FileReferenceSource item) {
            this.builder = new FileReferenceSourceBuilder(this, item);
        }

        public N and() {
            return (N)ThemeFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

