/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.AWSSubnets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSSubnetsFluent<A extends AWSSubnetsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> ids = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();

    public AWSSubnetsFluent() {
    }

    public AWSSubnetsFluent(AWSSubnets instance) {
        this.copyInstance(instance);
    }

    public A addAllToIds(Collection<String> items) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        for (String item : items) {
            this.ids.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNames(Collection<String> items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToIds(String ... items) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        for (String item : items) {
            this.ids.add(item);
        }
        return (A)((Object)this);
    }

    public A addToIds(int index, String item) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        this.ids.add(index, item);
        return (A)((Object)this);
    }

    public A addToNames(String ... items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)((Object)this);
    }

    public A addToNames(int index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(AWSSubnets instance) {
        AWSSubnets aWSSubnets = instance = instance != null ? instance : new AWSSubnets();
        if (instance != null) {
            this.withIds(instance.getIds());
            this.withNames(instance.getNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSSubnetsFluent that = (AWSSubnetsFluent)((Object)o);
        if (!Objects.equals(this.ids, that.ids)) {
            return false;
        }
        if (!Objects.equals(this.names, that.names)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstId() {
        return this.ids.get(0);
    }

    public String getFirstName() {
        return this.names.get(0);
    }

    public String getId(int index) {
        return this.ids.get(index);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public String getLastId() {
        return this.ids.get(this.ids.size() - 1);
    }

    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    public String getMatchingId(Predicate<String> predicate) {
        for (String item : this.ids) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName(int index) {
        return this.names.get(index);
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasIds() {
        return this.ids != null && !this.ids.isEmpty();
    }

    public boolean hasMatchingId(Predicate<String> predicate) {
        for (String item : this.ids) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.names, this.additionalProperties);
    }

    public A removeAllFromIds(Collection<String> items) {
        if (this.ids == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ids.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNames(Collection<String> items) {
        if (this.names == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromIds(String ... items) {
        if (this.ids == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ids.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNames(String ... items) {
        if (this.names == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToIds(int index, String item) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        this.ids.set(index, item);
        return (A)((Object)this);
    }

    public A setToNames(int index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ids != null && !this.ids.isEmpty()) {
            sb.append("ids:");
            sb.append(this.ids);
            sb.append(",");
        }
        if (this.names != null && !this.names.isEmpty()) {
            sb.append("names:");
            sb.append(this.names);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withIds(List<String> ids) {
        if (ids != null) {
            this.ids = new ArrayList<String>();
            for (String item : ids) {
                this.addToIds(item);
            }
        } else {
            this.ids = null;
        }
        return (A)((Object)this);
    }

    public A withIds(String ... ids) {
        if (this.ids != null) {
            this.ids.clear();
            this._visitables.remove((Object)"ids");
        }
        if (ids != null) {
            for (String item : ids) {
                this.addToIds(item);
            }
        }
        return (A)((Object)this);
    }

    public A withNames(List<String> names) {
        if (names != null) {
            this.names = new ArrayList<String>();
            for (String item : names) {
                this.addToNames(item);
            }
        } else {
            this.names = null;
        }
        return (A)((Object)this);
    }

    public A withNames(String ... names) {
        if (this.names != null) {
            this.names.clear();
            this._visitables.remove((Object)"names");
        }
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)((Object)this);
    }
}

