package io.fabric8.openshift.api.model.operatorhub.manifests;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PackageManifestFluentImpl<A extends io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder> channels =  new java.util.ArrayList<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder>();
    private java.lang.String defaultChannel;
    private java.lang.String packageName;

    public PackageManifestFluentImpl() {
    }

    public PackageManifestFluentImpl(io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifest instance) {
        this.withChannels(instance.getChannels()); 
        this.withDefaultChannel(instance.getDefaultChannel()); 
        this.withPackageName(instance.getPackageName()); 
    }

    public A addToChannels(int index,io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item) {
        if (this.channels == null) {this.channels = new java.util.ArrayList<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder>();}
        io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(item);_visitables.get("channels").add(index >= 0 ? index : _visitables.get("channels").size(), builder);this.channels.add(index >= 0 ? index : channels.size(), builder); return (A)this;
    }

    public A setToChannels(int index,io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item) {
        if (this.channels == null) {this.channels = new java.util.ArrayList<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder>();}
        io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(item);
        if (index < 0 || index >= _visitables.get("channels").size()) { _visitables.get("channels").add(builder); } else { _visitables.get("channels").set(index, builder);}
        if (index < 0 || index >= channels.size()) { channels.add(builder); } else { channels.set(index, builder);}
         return (A)this;
    }

    public A addToChannels(io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel... items) {
        if (this.channels == null) {this.channels = new java.util.ArrayList<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder>();}
        for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item : items) {io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(item);_visitables.get("channels").add(builder);this.channels.add(builder);} return (A)this;
    }

    public A addAllToChannels(java.util.Collection<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel> items) {
        if (this.channels == null) {this.channels = new java.util.ArrayList<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder>();}
        for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item : items) {io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(item);_visitables.get("channels").add(builder);this.channels.add(builder);} return (A)this;
    }

    public A removeFromChannels(io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel... items) {
        for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item : items) {io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(item);_visitables.get("channels").remove(builder);if (this.channels != null) {this.channels.remove(builder);}} return (A)this;
    }

    public A removeAllFromChannels(java.util.Collection<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel> items) {
        for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item : items) {io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(item);_visitables.get("channels").remove(builder);if (this.channels != null) {this.channels.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromChannels(java.util.function.Predicate<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder> predicate) {
        if (channels == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder> each = channels.iterator();
        final List visitables = _visitables.get("channels");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildChannels instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel> getChannels() {
        return build(channels);
    }

    public java.util.List<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel> buildChannels() {
        return build(channels);
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel buildChannel(int index) {
        return this.channels.get(index).build();
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel buildFirstChannel() {
        return this.channels.get(0).build();
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel buildLastChannel() {
        return this.channels.get(channels.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel buildMatchingChannel(java.util.function.Predicate<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder item: channels) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingChannel(java.util.function.Predicate<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder item: channels) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withChannels(java.util.List<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel> channels) {
        if (this.channels != null) { _visitables.get("channels").removeAll(this.channels);}
        if (channels != null) {this.channels = new java.util.ArrayList<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder>(); for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item : channels){this.addToChannels(item);}} else { this.channels = null;} return (A) this;
    }

    public A withChannels(io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel... channels) {
        if (this.channels != null) {this.channels.clear();}
        if (channels != null) {for (io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item :channels){ this.addToChannels(item);}} return (A) this;
    }

    public java.lang.Boolean hasChannels() {
        return channels != null && !channels.isEmpty();
    }

    public A addNewChannel(java.lang.String currentCSV,java.lang.String name) {
        return (A)addToChannels(new PackageChannel(currentCSV, name));
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> addNewChannel() {
        return new io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluentImpl.ChannelsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> addNewChannelLike(io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item) {
        return new io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluentImpl.ChannelsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> setNewChannelLike(int index,io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item) {
        return new io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluentImpl.ChannelsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editChannel(int index) {
        if (channels.size() <= index) throw new RuntimeException("Can't edit channels. Index exceeds size.");
        return setNewChannelLike(index, buildChannel(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editFirstChannel() {
        if (channels.size() == 0) throw new RuntimeException("Can't edit first channels. The list is empty.");
        return setNewChannelLike(0, buildChannel(0));
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editLastChannel() {
        int index = channels.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last channels. The list is empty.");
        return setNewChannelLike(index, buildChannel(index));
    }

    public io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<A> editMatchingChannel(java.util.function.Predicate<io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder> predicate) {
        int index = -1;
        for (int i=0;i<channels.size();i++) { 
        if (predicate.test(channels.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching channels. No match found.");
        return setNewChannelLike(index, buildChannel(index));
    }

    public java.lang.String getDefaultChannel() {
        return this.defaultChannel;
    }

    public A withDefaultChannel(java.lang.String defaultChannel) {
        this.defaultChannel=defaultChannel; return (A) this;
    }

    public java.lang.Boolean hasDefaultChannel() {
        return this.defaultChannel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDefaultChannel instead.
     */
        public A withNewDefaultChannel(java.lang.String arg0) {
        return (A)withDefaultChannel(new String(arg0));
    }

    public java.lang.String getPackageName() {
        return this.packageName;
    }

    public A withPackageName(java.lang.String packageName) {
        this.packageName=packageName; return (A) this;
    }

    public java.lang.Boolean hasPackageName() {
        return this.packageName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPackageName instead.
     */
        public A withNewPackageName(java.lang.String arg0) {
        return (A)withPackageName(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PackageManifestFluentImpl that = (PackageManifestFluentImpl) o;
        if (channels != null ? !channels.equals(that.channels) :that.channels != null) return false;
        if (defaultChannel != null ? !defaultChannel.equals(that.defaultChannel) :that.defaultChannel != null) return false;
        if (packageName != null ? !packageName.equals(that.packageName) :that.packageName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channels,  defaultChannel,  packageName,  super.hashCode());
    }

    public class ChannelsNestedImpl<N> extends io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelFluentImpl<io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<N>> implements io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent.ChannelsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder builder;
        private final int index;

            ChannelsNestedImpl(int index,io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(this, item);
                        
            }

            ChannelsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder(this);
                        
            }

            public N and() {
                return (N) PackageManifestFluentImpl.this.setToChannels(index,builder.build());
            }

            public N endChannel() {
                return and();
            }
    }


}
