package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IconBuilder extends IconFluentImpl<IconBuilder> implements VisitableBuilder<Icon,IconBuilder>{
  public IconBuilder() {
    this(false);
  }
  public IconBuilder(Boolean validationEnabled) {
    this(new Icon(), validationEnabled);
  }
  public IconBuilder(IconFluent<?> fluent) {
    this(fluent, false);
  }
  public IconBuilder(IconFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Icon(), validationEnabled);
  }
  public IconBuilder(IconFluent<?> fluent,Icon instance) {
    this(fluent, instance, false);
  }
  public IconBuilder(IconFluent<?> fluent,Icon instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBase64data(instance.getBase64data()); 
    fluent.withMediatype(instance.getMediatype()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IconBuilder(Icon instance) {
    this(instance,false);
  }
  public IconBuilder(Icon instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBase64data(instance.getBase64data()); 
    this.withMediatype(instance.getMediatype()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IconFluent<?> fluent;
  Boolean validationEnabled;
  public Icon build() {
    Icon buildable = new Icon(fluent.getBase64data(),fluent.getMediatype());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}