package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RequirementStatusBuilder extends RequirementStatusFluentImpl<RequirementStatusBuilder> implements VisitableBuilder<RequirementStatus,RequirementStatusBuilder>{
  public RequirementStatusBuilder() {
    this(false);
  }
  public RequirementStatusBuilder(Boolean validationEnabled) {
    this(new RequirementStatus(), validationEnabled);
  }
  public RequirementStatusBuilder(RequirementStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RequirementStatusBuilder(RequirementStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RequirementStatus(), validationEnabled);
  }
  public RequirementStatusBuilder(RequirementStatusFluent<?> fluent,RequirementStatus instance) {
    this(fluent, instance, false);
  }
  public RequirementStatusBuilder(RequirementStatusFluent<?> fluent,RequirementStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDependents(instance.getDependents()); 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withName(instance.getName()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withUuid(instance.getUuid()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RequirementStatusBuilder(RequirementStatus instance) {
    this(instance,false);
  }
  public RequirementStatusBuilder(RequirementStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDependents(instance.getDependents()); 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withMessage(instance.getMessage()); 
    this.withName(instance.getName()); 
    this.withStatus(instance.getStatus()); 
    this.withUuid(instance.getUuid()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RequirementStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RequirementStatus build() {
    RequirementStatus buildable = new RequirementStatus(fluent.getDependents(),fluent.getGroup(),fluent.getKind(),fluent.getMessage(),fluent.getName(),fluent.getStatus(),fluent.getUuid(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}