package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PackageManifestSpecBuilder extends PackageManifestSpecFluentImpl<PackageManifestSpecBuilder> implements VisitableBuilder<PackageManifestSpec,PackageManifestSpecBuilder>{
  public PackageManifestSpecBuilder() {
    this(false);
  }
  public PackageManifestSpecBuilder(Boolean validationEnabled) {
    this(new PackageManifestSpec(), validationEnabled);
  }
  public PackageManifestSpecBuilder(PackageManifestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PackageManifestSpecBuilder(PackageManifestSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PackageManifestSpec(), validationEnabled);
  }
  public PackageManifestSpecBuilder(PackageManifestSpecFluent<?> fluent,PackageManifestSpec instance) {
    this(fluent, instance, false);
  }
  public PackageManifestSpecBuilder(PackageManifestSpecFluent<?> fluent,PackageManifestSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PackageManifestSpecBuilder(PackageManifestSpec instance) {
    this(instance,false);
  }
  public PackageManifestSpecBuilder(PackageManifestSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PackageManifestSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PackageManifestSpec build() {
    PackageManifestSpec buildable = new PackageManifestSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}