package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIResourceReferenceBuilder extends APIResourceReferenceFluentImpl<APIResourceReferenceBuilder> implements VisitableBuilder<APIResourceReference,APIResourceReferenceBuilder>{
  public APIResourceReferenceBuilder() {
    this(false);
  }
  public APIResourceReferenceBuilder(Boolean validationEnabled) {
    this(new APIResourceReference(), validationEnabled);
  }
  public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIResourceReference(), validationEnabled);
  }
  public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent,APIResourceReference instance) {
    this(fluent, instance, false);
  }
  public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent,APIResourceReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIResourceReferenceBuilder(APIResourceReference instance) {
    this(instance,false);
  }
  public APIResourceReferenceBuilder(APIResourceReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIResourceReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public APIResourceReference build() {
    APIResourceReference buildable = new APIResourceReference(fluent.getKind(),fluent.getName(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}