package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CatalogSourceStatusFluentImpl<A extends CatalogSourceStatusFluent<A>> extends BaseFluent<A> implements CatalogSourceStatusFluent<A>{
  public CatalogSourceStatusFluentImpl() {
  }
  public CatalogSourceStatusFluentImpl(CatalogSourceStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withConfigMapReference(instance.getConfigMapReference());
      this.withConnectionState(instance.getConnectionState());
      this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withRegistryService(instance.getRegistryService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ConfigMapResourceReferenceBuilder configMapReference;
  private GRPCConnectionStateBuilder connectionState;
  private String latestImageRegistryPoll;
  private String message;
  private String reason;
  private RegistryServiceStatusBuilder registryService;
  private Map<String,Object> additionalProperties;
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildConfigMapReference instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapResourceReference getConfigMapReference() {
    return this.configMapReference!=null ?this.configMapReference.build():null;
  }
  public ConfigMapResourceReference buildConfigMapReference() {
    return this.configMapReference!=null ?this.configMapReference.build():null;
  }
  public A withConfigMapReference(ConfigMapResourceReference configMapReference) {
    _visitables.get("configMapReference").remove(this.configMapReference);
    if (configMapReference!=null){ this.configMapReference= new ConfigMapResourceReferenceBuilder(configMapReference); _visitables.get("configMapReference").add(this.configMapReference);} else { this.configMapReference = null; _visitables.get("configMapReference").remove(this.configMapReference); } return (A) this;
  }
  public Boolean hasConfigMapReference() {
    return this.configMapReference != null;
  }
  public A withNewConfigMapReference(String lastUpdateTime,String name,String namespace,String resourceVersion,String uid) {
    return (A)withConfigMapReference(new ConfigMapResourceReference(lastUpdateTime, name, namespace, resourceVersion, uid));
  }
  public CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<A> withNewConfigMapReference() {
    return new CatalogSourceStatusFluentImpl.ConfigMapReferenceNestedImpl();
  }
  public CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<A> withNewConfigMapReferenceLike(ConfigMapResourceReference item) {
    return new CatalogSourceStatusFluentImpl.ConfigMapReferenceNestedImpl(item);
  }
  public CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<A> editConfigMapReference() {
    return withNewConfigMapReferenceLike(getConfigMapReference());
  }
  public CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<A> editOrNewConfigMapReference() {
    return withNewConfigMapReferenceLike(getConfigMapReference() != null ? getConfigMapReference(): new ConfigMapResourceReferenceBuilder().build());
  }
  public CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<A> editOrNewConfigMapReferenceLike(ConfigMapResourceReference item) {
    return withNewConfigMapReferenceLike(getConfigMapReference() != null ? getConfigMapReference(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildConnectionState instead.
   * @return The buildable object.
   */
  @Deprecated
  public GRPCConnectionState getConnectionState() {
    return this.connectionState!=null ?this.connectionState.build():null;
  }
  public GRPCConnectionState buildConnectionState() {
    return this.connectionState!=null ?this.connectionState.build():null;
  }
  public A withConnectionState(GRPCConnectionState connectionState) {
    _visitables.get("connectionState").remove(this.connectionState);
    if (connectionState!=null){ this.connectionState= new GRPCConnectionStateBuilder(connectionState); _visitables.get("connectionState").add(this.connectionState);} else { this.connectionState = null; _visitables.get("connectionState").remove(this.connectionState); } return (A) this;
  }
  public Boolean hasConnectionState() {
    return this.connectionState != null;
  }
  public A withNewConnectionState(String address,String lastConnect,String lastObservedState) {
    return (A)withConnectionState(new GRPCConnectionState(address, lastConnect, lastObservedState));
  }
  public CatalogSourceStatusFluentImpl.ConnectionStateNested<A> withNewConnectionState() {
    return new CatalogSourceStatusFluentImpl.ConnectionStateNestedImpl();
  }
  public CatalogSourceStatusFluentImpl.ConnectionStateNested<A> withNewConnectionStateLike(GRPCConnectionState item) {
    return new CatalogSourceStatusFluentImpl.ConnectionStateNestedImpl(item);
  }
  public CatalogSourceStatusFluentImpl.ConnectionStateNested<A> editConnectionState() {
    return withNewConnectionStateLike(getConnectionState());
  }
  public CatalogSourceStatusFluentImpl.ConnectionStateNested<A> editOrNewConnectionState() {
    return withNewConnectionStateLike(getConnectionState() != null ? getConnectionState(): new GRPCConnectionStateBuilder().build());
  }
  public CatalogSourceStatusFluentImpl.ConnectionStateNested<A> editOrNewConnectionStateLike(GRPCConnectionState item) {
    return withNewConnectionStateLike(getConnectionState() != null ? getConnectionState(): item);
  }
  public String getLatestImageRegistryPoll() {
    return this.latestImageRegistryPoll;
  }
  public A withLatestImageRegistryPoll(String latestImageRegistryPoll) {
    this.latestImageRegistryPoll=latestImageRegistryPoll; return (A) this;
  }
  public Boolean hasLatestImageRegistryPoll() {
    return this.latestImageRegistryPoll != null;
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRegistryService instead.
   * @return The buildable object.
   */
  @Deprecated
  public RegistryServiceStatus getRegistryService() {
    return this.registryService!=null ?this.registryService.build():null;
  }
  public RegistryServiceStatus buildRegistryService() {
    return this.registryService!=null ?this.registryService.build():null;
  }
  public A withRegistryService(RegistryServiceStatus registryService) {
    _visitables.get("registryService").remove(this.registryService);
    if (registryService!=null){ this.registryService= new RegistryServiceStatusBuilder(registryService); _visitables.get("registryService").add(this.registryService);} else { this.registryService = null; _visitables.get("registryService").remove(this.registryService); } return (A) this;
  }
  public Boolean hasRegistryService() {
    return this.registryService != null;
  }
  public A withNewRegistryService(String createdAt,String port,String protocol,String serviceName,String serviceNamespace) {
    return (A)withRegistryService(new RegistryServiceStatus(createdAt, port, protocol, serviceName, serviceNamespace));
  }
  public CatalogSourceStatusFluentImpl.RegistryServiceNested<A> withNewRegistryService() {
    return new CatalogSourceStatusFluentImpl.RegistryServiceNestedImpl();
  }
  public CatalogSourceStatusFluentImpl.RegistryServiceNested<A> withNewRegistryServiceLike(RegistryServiceStatus item) {
    return new CatalogSourceStatusFluentImpl.RegistryServiceNestedImpl(item);
  }
  public CatalogSourceStatusFluentImpl.RegistryServiceNested<A> editRegistryService() {
    return withNewRegistryServiceLike(getRegistryService());
  }
  public CatalogSourceStatusFluentImpl.RegistryServiceNested<A> editOrNewRegistryService() {
    return withNewRegistryServiceLike(getRegistryService() != null ? getRegistryService(): new RegistryServiceStatusBuilder().build());
  }
  public CatalogSourceStatusFluentImpl.RegistryServiceNested<A> editOrNewRegistryServiceLike(RegistryServiceStatus item) {
    return withNewRegistryServiceLike(getRegistryService() != null ? getRegistryService(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CatalogSourceStatusFluentImpl that = (CatalogSourceStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(configMapReference, that.configMapReference)) return false;

    if (!java.util.Objects.equals(connectionState, that.connectionState)) return false;

    if (!java.util.Objects.equals(latestImageRegistryPoll, that.latestImageRegistryPoll)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(reason, that.reason)) return false;

    if (!java.util.Objects.equals(registryService, that.registryService)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  configMapReference,  connectionState,  latestImageRegistryPoll,  message,  reason,  registryService,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configMapReference != null) { sb.append("configMapReference:"); sb.append(configMapReference + ","); }
    if (connectionState != null) { sb.append("connectionState:"); sb.append(connectionState + ","); }
    if (latestImageRegistryPoll != null) { sb.append("latestImageRegistryPoll:"); sb.append(latestImageRegistryPoll + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (registryService != null) { sb.append("registryService:"); sb.append(registryService + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigMapReferenceNestedImpl<N> extends ConfigMapResourceReferenceFluentImpl<CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<N>> implements CatalogSourceStatusFluentImpl.ConfigMapReferenceNested<N>,Nested<N>{
    ConfigMapReferenceNestedImpl(ConfigMapResourceReference item) {
      this.builder = new ConfigMapResourceReferenceBuilder(this, item);
    }
    ConfigMapReferenceNestedImpl() {
      this.builder = new ConfigMapResourceReferenceBuilder(this);
    }
    ConfigMapResourceReferenceBuilder builder;
    public N and() {
      return (N) CatalogSourceStatusFluentImpl.this.withConfigMapReference(builder.build());
    }
    public N endConfigMapReference() {
      return and();
    }
    
  }
  class ConnectionStateNestedImpl<N> extends GRPCConnectionStateFluentImpl<CatalogSourceStatusFluentImpl.ConnectionStateNested<N>> implements CatalogSourceStatusFluentImpl.ConnectionStateNested<N>,Nested<N>{
    ConnectionStateNestedImpl(GRPCConnectionState item) {
      this.builder = new GRPCConnectionStateBuilder(this, item);
    }
    ConnectionStateNestedImpl() {
      this.builder = new GRPCConnectionStateBuilder(this);
    }
    GRPCConnectionStateBuilder builder;
    public N and() {
      return (N) CatalogSourceStatusFluentImpl.this.withConnectionState(builder.build());
    }
    public N endConnectionState() {
      return and();
    }
    
  }
  class RegistryServiceNestedImpl<N> extends RegistryServiceStatusFluentImpl<CatalogSourceStatusFluentImpl.RegistryServiceNested<N>> implements CatalogSourceStatusFluentImpl.RegistryServiceNested<N>,Nested<N>{
    RegistryServiceNestedImpl(RegistryServiceStatus item) {
      this.builder = new RegistryServiceStatusBuilder(this, item);
    }
    RegistryServiceNestedImpl() {
      this.builder = new RegistryServiceStatusBuilder(this);
    }
    RegistryServiceStatusBuilder builder;
    public N and() {
      return (N) CatalogSourceStatusFluentImpl.this.withRegistryService(builder.build());
    }
    public N endRegistryService() {
      return and();
    }
    
  }
  
}