package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceVersionStatusBuilder extends ClusterServiceVersionStatusFluentImpl<ClusterServiceVersionStatusBuilder> implements VisitableBuilder<ClusterServiceVersionStatus,ClusterServiceVersionStatusBuilder>{
  public ClusterServiceVersionStatusBuilder() {
    this(false);
  }
  public ClusterServiceVersionStatusBuilder(Boolean validationEnabled) {
    this(new ClusterServiceVersionStatus(), validationEnabled);
  }
  public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceVersionStatus(), validationEnabled);
  }
  public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent,ClusterServiceVersionStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent,ClusterServiceVersionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCertsLastUpdated(instance.getCertsLastUpdated());
      fluent.withCertsRotateAt(instance.getCertsRotateAt());
      fluent.withCleanup(instance.getCleanup());
      fluent.withConditions(instance.getConditions());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
      fluent.withReason(instance.getReason());
      fluent.withRequirementStatus(instance.getRequirementStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatus instance) {
    this(instance,false);
  }
  public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCertsLastUpdated(instance.getCertsLastUpdated());
      this.withCertsRotateAt(instance.getCertsRotateAt());
      this.withCleanup(instance.getCleanup());
      this.withConditions(instance.getConditions());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withReason(instance.getReason());
      this.withRequirementStatus(instance.getRequirementStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceVersionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceVersionStatus build() {
    ClusterServiceVersionStatus buildable = new ClusterServiceVersionStatus(fluent.getCertsLastUpdated(),fluent.getCertsRotateAt(),fluent.getCleanup(),fluent.getConditions(),fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason(),fluent.getRequirementStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}