package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallPlanBuilder extends InstallPlanFluentImpl<InstallPlanBuilder> implements VisitableBuilder<InstallPlan,InstallPlanBuilder>{
  public InstallPlanBuilder() {
    this(false);
  }
  public InstallPlanBuilder(Boolean validationEnabled) {
    this(new InstallPlan(), validationEnabled);
  }
  public InstallPlanBuilder(InstallPlanFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallPlanBuilder(InstallPlanFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallPlan(), validationEnabled);
  }
  public InstallPlanBuilder(InstallPlanFluent<?> fluent,InstallPlan instance) {
    this(fluent, instance, false);
  }
  public InstallPlanBuilder(InstallPlanFluent<?> fluent,InstallPlan instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InstallPlanBuilder(InstallPlan instance) {
    this(instance,false);
  }
  public InstallPlanBuilder(InstallPlan instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InstallPlanFluent<?> fluent;
  Boolean validationEnabled;
  public InstallPlan build() {
    InstallPlan buildable = new InstallPlan(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}