package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceListBuilder extends ResourceListFluentImpl<ResourceListBuilder> implements VisitableBuilder<ResourceList,ResourceListBuilder>{
  public ResourceListBuilder() {
    this(false);
  }
  public ResourceListBuilder(Boolean validationEnabled) {
    this(new ResourceList(), validationEnabled);
  }
  public ResourceListBuilder(ResourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceListBuilder(ResourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceList(), validationEnabled);
  }
  public ResourceListBuilder(ResourceListFluent<?> fluent,ResourceList instance) {
    this(fluent, instance, false);
  }
  public ResourceListBuilder(ResourceListFluent<?> fluent,ResourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withInstances(instance.getInstances());
      fluent.withKind(instance.getKind());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceListBuilder(ResourceList instance) {
    this(instance,false);
  }
  public ResourceListBuilder(ResourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withInstances(instance.getInstances());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceListFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceList build() {
    ResourceList buildable = new ResourceList(fluent.getGroup(),fluent.getInstances(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}