package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ComponentsFluent<A extends ComponentsFluent<A>> extends BaseFluent<A>{
  public ComponentsFluent() {
  }
  
  public ComponentsFluent(Components instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder labelSelector;
  private ArrayList<RichReferenceBuilder> refs = new ArrayList<RichReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Components instance) {
    instance = (instance != null ? instance : new Components());
    if (instance != null) {
          this.withLabelSelector(instance.getLabelSelector());
          this.withRefs(instance.getRefs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LabelSelector buildLabelSelector() {
    return this.labelSelector != null ? this.labelSelector.build() : null;
  }
  
  public A withLabelSelector(LabelSelector labelSelector) {
    this._visitables.remove("labelSelector");
    if (labelSelector != null) {
        this.labelSelector = new LabelSelectorBuilder(labelSelector);
        this._visitables.get("labelSelector").add(this.labelSelector);
    } else {
        this.labelSelector = null;
        this._visitables.get("labelSelector").remove(this.labelSelector);
    }
    return (A) this;
  }
  
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  
  public LabelSelectorNested<A> withNewLabelSelector() {
    return new LabelSelectorNested(null);
  }
  
  public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new LabelSelectorNested(item);
  }
  
  public LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(null));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(item));
  }
  
  public A addToRefs(int index,RichReference item) {
    if (this.refs == null) {this.refs = new ArrayList<RichReferenceBuilder>();}
    RichReferenceBuilder builder = new RichReferenceBuilder(item);
    if (index < 0 || index >= refs.size()) {
        _visitables.get("refs").add(builder);
        refs.add(builder);
    } else {
        _visitables.get("refs").add(builder);
        refs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRefs(int index,RichReference item) {
    if (this.refs == null) {this.refs = new ArrayList<RichReferenceBuilder>();}
    RichReferenceBuilder builder = new RichReferenceBuilder(item);
    if (index < 0 || index >= refs.size()) {
        _visitables.get("refs").add(builder);
        refs.add(builder);
    } else {
        _visitables.get("refs").add(builder);
        refs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRefs(io.fabric8.openshift.api.model.operatorhub.v1.RichReference... items) {
    if (this.refs == null) {this.refs = new ArrayList<RichReferenceBuilder>();}
    for (RichReference item : items) {RichReferenceBuilder builder = new RichReferenceBuilder(item);_visitables.get("refs").add(builder);this.refs.add(builder);} return (A)this;
  }
  
  public A addAllToRefs(Collection<RichReference> items) {
    if (this.refs == null) {this.refs = new ArrayList<RichReferenceBuilder>();}
    for (RichReference item : items) {RichReferenceBuilder builder = new RichReferenceBuilder(item);_visitables.get("refs").add(builder);this.refs.add(builder);} return (A)this;
  }
  
  public A removeFromRefs(io.fabric8.openshift.api.model.operatorhub.v1.RichReference... items) {
    if (this.refs == null) return (A)this;
    for (RichReference item : items) {RichReferenceBuilder builder = new RichReferenceBuilder(item);_visitables.get("refs").remove(builder); this.refs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRefs(Collection<RichReference> items) {
    if (this.refs == null) return (A)this;
    for (RichReference item : items) {RichReferenceBuilder builder = new RichReferenceBuilder(item);_visitables.get("refs").remove(builder); this.refs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRefs(Predicate<RichReferenceBuilder> predicate) {
    if (refs == null) return (A) this;
    final Iterator<RichReferenceBuilder> each = refs.iterator();
    final List visitables = _visitables.get("refs");
    while (each.hasNext()) {
      RichReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RichReference> buildRefs() {
    return this.refs != null ? build(refs) : null;
  }
  
  public RichReference buildRef(int index) {
    return this.refs.get(index).build();
  }
  
  public RichReference buildFirstRef() {
    return this.refs.get(0).build();
  }
  
  public RichReference buildLastRef() {
    return this.refs.get(refs.size() - 1).build();
  }
  
  public RichReference buildMatchingRef(Predicate<RichReferenceBuilder> predicate) {
      for (RichReferenceBuilder item : refs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRef(Predicate<RichReferenceBuilder> predicate) {
      for (RichReferenceBuilder item : refs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRefs(List<RichReference> refs) {
    if (this.refs != null) {
      this._visitables.get("refs").clear();
    }
    if (refs != null) {
        this.refs = new ArrayList();
        for (RichReference item : refs) {
          this.addToRefs(item);
        }
    } else {
      this.refs = null;
    }
    return (A) this;
  }
  
  public A withRefs(io.fabric8.openshift.api.model.operatorhub.v1.RichReference... refs) {
    if (this.refs != null) {
        this.refs.clear();
        _visitables.remove("refs");
    }
    if (refs != null) {
      for (RichReference item : refs) {
        this.addToRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRefs() {
    return this.refs != null && !this.refs.isEmpty();
  }
  
  public RefsNested<A> addNewRef() {
    return new RefsNested(-1, null);
  }
  
  public RefsNested<A> addNewRefLike(RichReference item) {
    return new RefsNested(-1, item);
  }
  
  public RefsNested<A> setNewRefLike(int index,RichReference item) {
    return new RefsNested(index, item);
  }
  
  public RefsNested<A> editRef(int index) {
    if (refs.size() <= index) throw new RuntimeException("Can't edit refs. Index exceeds size.");
    return setNewRefLike(index, buildRef(index));
  }
  
  public RefsNested<A> editFirstRef() {
    if (refs.size() == 0) throw new RuntimeException("Can't edit first refs. The list is empty.");
    return setNewRefLike(0, buildRef(0));
  }
  
  public RefsNested<A> editLastRef() {
    int index = refs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last refs. The list is empty.");
    return setNewRefLike(index, buildRef(index));
  }
  
  public RefsNested<A> editMatchingRef(Predicate<RichReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<refs.size();i++) { 
    if (predicate.test(refs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching refs. No match found.");
    return setNewRefLike(index, buildRef(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ComponentsFluent that = (ComponentsFluent) o;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;
    if (!java.util.Objects.equals(refs, that.refs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(labelSelector,  refs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (refs != null && !refs.isEmpty()) { sb.append("refs:"); sb.append(refs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LabelSelectorNested<N> extends LabelSelectorFluent<LabelSelectorNested<N>> implements Nested<N>{
    LabelSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ComponentsFluent.this.withLabelSelector(builder.build());
    }
    
    public N endLabelSelector() {
      return and();
    }
    
  
  }
  public class RefsNested<N> extends RichReferenceFluent<RefsNested<N>> implements Nested<N>{
    RefsNested(int index,RichReference item) {
      this.index = index;
      this.builder = new RichReferenceBuilder(this, item);
    }
    RichReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ComponentsFluent.this.setToRefs(index,builder.build());
    }
    
    public N endRef() {
      return and();
    }
    
  
  }

}