/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.packages.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescription;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescriptionFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.ChannelEntry;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.ChannelEntryBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.ChannelEntryFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.Deprecation;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.DeprecationBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.DeprecationFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.PackageChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PackageChannelFluent<A extends PackageChannelFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String currentCSV;
    private CSVDescriptionBuilder currentCSVDesc;
    private DeprecationBuilder deprecation;
    private ArrayList<ChannelEntryBuilder> entries = new ArrayList();
    private String name;

    public PackageChannelFluent() {
    }

    public PackageChannelFluent(PackageChannel instance) {
        this.copyInstance(instance);
    }

    public A addAllToEntries(Collection<ChannelEntry> items) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get((Object)"entries").add(builder);
            this.entries.add(builder);
        }
        return (A)((Object)this);
    }

    public EntriesNested<A> addNewEntry() {
        return new EntriesNested(-1, null);
    }

    public EntriesNested<A> addNewEntryLike(ChannelEntry item) {
        return new EntriesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToEntries(ChannelEntry ... items) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get((Object)"entries").add(builder);
            this.entries.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToEntries(int index, ChannelEntry item) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
        if (index < 0 || index >= this.entries.size()) {
            this._visitables.get((Object)"entries").add(builder);
            this.entries.add(builder);
        } else {
            this._visitables.get((Object)"entries").add(builder);
            this.entries.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CSVDescription buildCurrentCSVDesc() {
        return this.currentCSVDesc != null ? this.currentCSVDesc.build() : null;
    }

    public Deprecation buildDeprecation() {
        return this.deprecation != null ? this.deprecation.build() : null;
    }

    public List<ChannelEntry> buildEntries() {
        return this.entries != null ? PackageChannelFluent.build(this.entries) : null;
    }

    public ChannelEntry buildEntry(int index) {
        return this.entries.get(index).build();
    }

    public ChannelEntry buildFirstEntry() {
        return this.entries.get(0).build();
    }

    public ChannelEntry buildLastEntry() {
        return this.entries.get(this.entries.size() - 1).build();
    }

    public ChannelEntry buildMatchingEntry(Predicate<ChannelEntryBuilder> predicate) {
        for (ChannelEntryBuilder item : this.entries) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(PackageChannel instance) {
        PackageChannel packageChannel = instance = instance != null ? instance : new PackageChannel();
        if (instance != null) {
            this.withCurrentCSV(instance.getCurrentCSV());
            this.withCurrentCSVDesc(instance.getCurrentCSVDesc());
            this.withDeprecation(instance.getDeprecation());
            this.withEntries(instance.getEntries());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CurrentCSVDescNested<A> editCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(Optional.ofNullable(this.buildCurrentCSVDesc()).orElse(null));
    }

    public DeprecationNested<A> editDeprecation() {
        return this.withNewDeprecationLike(Optional.ofNullable(this.buildDeprecation()).orElse(null));
    }

    public EntriesNested<A> editEntry(int index) {
        if (this.entries.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "entries"));
        }
        return this.setNewEntryLike(index, this.buildEntry(index));
    }

    public EntriesNested<A> editFirstEntry() {
        if (this.entries.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "entries"));
        }
        return this.setNewEntryLike(0, this.buildEntry(0));
    }

    public EntriesNested<A> editLastEntry() {
        int index = this.entries.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "entries"));
        }
        return this.setNewEntryLike(index, this.buildEntry(index));
    }

    public EntriesNested<A> editMatchingEntry(Predicate<ChannelEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!predicate.test(this.entries.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "entries"));
        }
        return this.setNewEntryLike(index, this.buildEntry(index));
    }

    public CurrentCSVDescNested<A> editOrNewCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(Optional.ofNullable(this.buildCurrentCSVDesc()).orElse(new CSVDescriptionBuilder().build()));
    }

    public CurrentCSVDescNested<A> editOrNewCurrentCSVDescLike(CSVDescription item) {
        return this.withNewCurrentCSVDescLike(Optional.ofNullable(this.buildCurrentCSVDesc()).orElse(item));
    }

    public DeprecationNested<A> editOrNewDeprecation() {
        return this.withNewDeprecationLike(Optional.ofNullable(this.buildDeprecation()).orElse(new DeprecationBuilder().build()));
    }

    public DeprecationNested<A> editOrNewDeprecationLike(Deprecation item) {
        return this.withNewDeprecationLike(Optional.ofNullable(this.buildDeprecation()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackageChannelFluent that = (PackageChannelFluent)((Object)o);
        if (!Objects.equals(this.currentCSV, that.currentCSV)) {
            return false;
        }
        if (!Objects.equals((Object)this.currentCSVDesc, (Object)that.currentCSVDesc)) {
            return false;
        }
        if (!Objects.equals((Object)this.deprecation, (Object)that.deprecation)) {
            return false;
        }
        if (!Objects.equals(this.entries, that.entries)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCurrentCSV() {
        return this.currentCSV;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    public boolean hasCurrentCSVDesc() {
        return this.currentCSVDesc != null;
    }

    public boolean hasDeprecation() {
        return this.deprecation != null;
    }

    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    public boolean hasMatchingEntry(Predicate<ChannelEntryBuilder> predicate) {
        for (ChannelEntryBuilder item : this.entries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentCSV, this.currentCSVDesc, this.deprecation, this.entries, this.name, this.additionalProperties});
    }

    public A removeAllFromEntries(Collection<ChannelEntry> items) {
        if (this.entries == null) {
            return (A)((Object)this);
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get((Object)"entries").remove((Object)builder);
            this.entries.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromEntries(ChannelEntry ... items) {
        if (this.entries == null) {
            return (A)((Object)this);
        }
        for (ChannelEntry item : items) {
            ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
            this._visitables.get((Object)"entries").remove((Object)builder);
            this.entries.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEntries(Predicate<ChannelEntryBuilder> predicate) {
        if (this.entries == null) {
            return (A)((Object)this);
        }
        Iterator<ChannelEntryBuilder> each = this.entries.iterator();
        List visitables = this._visitables.get((Object)"entries");
        while (each.hasNext()) {
            ChannelEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public EntriesNested<A> setNewEntryLike(int index, ChannelEntry item) {
        return new EntriesNested(index, item);
    }

    public A setToEntries(int index, ChannelEntry item) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        ChannelEntryBuilder builder = new ChannelEntryBuilder(item);
        if (index < 0 || index >= this.entries.size()) {
            this._visitables.get((Object)"entries").add(builder);
            this.entries.add(builder);
        } else {
            this._visitables.get((Object)"entries").add(builder);
            this.entries.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentCSV != null) {
            sb.append("currentCSV:");
            sb.append(this.currentCSV);
            sb.append(",");
        }
        if (this.currentCSVDesc != null) {
            sb.append("currentCSVDesc:");
            sb.append((Object)this.currentCSVDesc);
            sb.append(",");
        }
        if (this.deprecation != null) {
            sb.append("deprecation:");
            sb.append((Object)this.deprecation);
            sb.append(",");
        }
        if (this.entries != null && !this.entries.isEmpty()) {
            sb.append("entries:");
            sb.append(this.entries);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCurrentCSV(String currentCSV) {
        this.currentCSV = currentCSV;
        return (A)((Object)this);
    }

    public A withCurrentCSVDesc(CSVDescription currentCSVDesc) {
        this._visitables.remove((Object)"currentCSVDesc");
        if (currentCSVDesc != null) {
            this.currentCSVDesc = new CSVDescriptionBuilder(currentCSVDesc);
            this._visitables.get((Object)"currentCSVDesc").add(this.currentCSVDesc);
        } else {
            this.currentCSVDesc = null;
            this._visitables.get((Object)"currentCSVDesc").remove((Object)this.currentCSVDesc);
        }
        return (A)((Object)this);
    }

    public A withDeprecation(Deprecation deprecation) {
        this._visitables.remove((Object)"deprecation");
        if (deprecation != null) {
            this.deprecation = new DeprecationBuilder(deprecation);
            this._visitables.get((Object)"deprecation").add(this.deprecation);
        } else {
            this.deprecation = null;
            this._visitables.get((Object)"deprecation").remove((Object)this.deprecation);
        }
        return (A)((Object)this);
    }

    public A withEntries(List<ChannelEntry> entries) {
        if (this.entries != null) {
            this._visitables.get((Object)"entries").clear();
        }
        if (entries != null) {
            this.entries = new ArrayList();
            for (ChannelEntry item : entries) {
                this.addToEntries(item);
            }
        } else {
            this.entries = null;
        }
        return (A)((Object)this);
    }

    public A withEntries(ChannelEntry ... entries) {
        if (this.entries != null) {
            this.entries.clear();
            this._visitables.remove((Object)"entries");
        }
        if (entries != null) {
            for (ChannelEntry item : entries) {
                this.addToEntries(item);
            }
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public CurrentCSVDescNested<A> withNewCurrentCSVDesc() {
        return new CurrentCSVDescNested(null);
    }

    public CurrentCSVDescNested<A> withNewCurrentCSVDescLike(CSVDescription item) {
        return new CurrentCSVDescNested(item);
    }

    public DeprecationNested<A> withNewDeprecation() {
        return new DeprecationNested(null);
    }

    public A withNewDeprecation(String message) {
        return this.withDeprecation(new Deprecation(message));
    }

    public DeprecationNested<A> withNewDeprecationLike(Deprecation item) {
        return new DeprecationNested(item);
    }

    public class EntriesNested<N>
    extends ChannelEntryFluent<EntriesNested<N>>
    implements Nested<N> {
        ChannelEntryBuilder builder;
        int index;

        EntriesNested(int index, ChannelEntry item) {
            this.index = index;
            this.builder = new ChannelEntryBuilder(this, item);
        }

        public N and() {
            return (N)PackageChannelFluent.this.setToEntries(this.index, this.builder.build());
        }

        public N endEntry() {
            return this.and();
        }
    }

    public class DeprecationNested<N>
    extends DeprecationFluent<DeprecationNested<N>>
    implements Nested<N> {
        DeprecationBuilder builder;

        DeprecationNested(Deprecation item) {
            this.builder = new DeprecationBuilder(this, item);
        }

        public N and() {
            return (N)PackageChannelFluent.this.withDeprecation(this.builder.build());
        }

        public N endDeprecation() {
            return this.and();
        }
    }

    public class CurrentCSVDescNested<N>
    extends CSVDescriptionFluent<CurrentCSVDescNested<N>>
    implements Nested<N> {
        CSVDescriptionBuilder builder;

        CurrentCSVDescNested(CSVDescription item) {
            this.builder = new CSVDescriptionBuilder(this, item);
        }

        public N and() {
            return (N)PackageChannelFluent.this.withCurrentCSVDesc(this.builder.build());
        }

        public N endCurrentCSVDesc() {
            return this.and();
        }
    }
}

