package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageStateStatusBuilder extends StorageStateStatusFluentImpl<StorageStateStatusBuilder> implements VisitableBuilder<StorageStateStatus,StorageStateStatusBuilder>{
  public StorageStateStatusBuilder() {
    this(false);
  }
  public StorageStateStatusBuilder(Boolean validationEnabled) {
    this(new StorageStateStatus(), validationEnabled);
  }
  public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageStateStatus(), validationEnabled);
  }
  public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent,StorageStateStatus instance) {
    this(fluent, instance, false);
  }
  public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent,StorageStateStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
      fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      fluent.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageStateStatusBuilder(StorageStateStatus instance) {
    this(instance,false);
  }
  public StorageStateStatusBuilder(StorageStateStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
      this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      this.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageStateStatusFluent<?> fluent;
  Boolean validationEnabled;
  public StorageStateStatus build() {
    StorageStateStatus buildable = new StorageStateStatus(fluent.getCurrentStorageVersionHash(),fluent.getLastHeartbeatTime(),fluent.getPersistedStorageVersionHashes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}