package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionMigrationBuilder extends StorageVersionMigrationFluentImpl<StorageVersionMigrationBuilder> implements VisitableBuilder<StorageVersionMigration,StorageVersionMigrationBuilder>{
  public StorageVersionMigrationBuilder() {
    this(false);
  }
  public StorageVersionMigrationBuilder(Boolean validationEnabled) {
    this(new StorageVersionMigration(), validationEnabled);
  }
  public StorageVersionMigrationBuilder(StorageVersionMigrationFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionMigrationBuilder(StorageVersionMigrationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionMigration(), validationEnabled);
  }
  public StorageVersionMigrationBuilder(StorageVersionMigrationFluent<?> fluent,StorageVersionMigration instance) {
    this(fluent, instance, false);
  }
  public StorageVersionMigrationBuilder(StorageVersionMigrationFluent<?> fluent,StorageVersionMigration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionMigrationBuilder(StorageVersionMigration instance) {
    this(instance,false);
  }
  public StorageVersionMigrationBuilder(StorageVersionMigration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionMigrationFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionMigration build() {
    StorageVersionMigration buildable = new StorageVersionMigration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}