package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionMigrationSpecBuilder extends StorageVersionMigrationSpecFluentImpl<StorageVersionMigrationSpecBuilder> implements VisitableBuilder<StorageVersionMigrationSpec,StorageVersionMigrationSpecBuilder>{
  public StorageVersionMigrationSpecBuilder() {
    this(false);
  }
  public StorageVersionMigrationSpecBuilder(Boolean validationEnabled) {
    this(new StorageVersionMigrationSpec(), validationEnabled);
  }
  public StorageVersionMigrationSpecBuilder(StorageVersionMigrationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionMigrationSpecBuilder(StorageVersionMigrationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionMigrationSpec(), validationEnabled);
  }
  public StorageVersionMigrationSpecBuilder(StorageVersionMigrationSpecFluent<?> fluent,StorageVersionMigrationSpec instance) {
    this(fluent, instance, false);
  }
  public StorageVersionMigrationSpecBuilder(StorageVersionMigrationSpecFluent<?> fluent,StorageVersionMigrationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContinueToken(instance.getContinueToken());
      fluent.withResource(instance.getResource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionMigrationSpecBuilder(StorageVersionMigrationSpec instance) {
    this(instance,false);
  }
  public StorageVersionMigrationSpecBuilder(StorageVersionMigrationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContinueToken(instance.getContinueToken());
      this.withResource(instance.getResource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionMigrationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionMigrationSpec build() {
    StorageVersionMigrationSpec buildable = new StorageVersionMigrationSpec(fluent.getContinueToken(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}