/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StorageStateStatusFluent<A extends StorageStateStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String currentStorageVersionHash;
    private String lastHeartbeatTime;
    private List<String> persistedStorageVersionHashes = new ArrayList<String>();

    public StorageStateStatusFluent() {
    }

    public StorageStateStatusFluent(StorageStateStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToPersistedStorageVersionHashes(Collection<String> items) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        for (String item : items) {
            this.persistedStorageVersionHashes.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPersistedStorageVersionHashes(String ... items) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        for (String item : items) {
            this.persistedStorageVersionHashes.add(item);
        }
        return (A)((Object)this);
    }

    public A addToPersistedStorageVersionHashes(int index, String item) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        this.persistedStorageVersionHashes.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(StorageStateStatus instance) {
        StorageStateStatus storageStateStatus = instance = instance != null ? instance : new StorageStateStatus();
        if (instance != null) {
            this.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
            this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
            this.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageStateStatusFluent that = (StorageStateStatusFluent)((Object)o);
        if (!Objects.equals(this.currentStorageVersionHash, that.currentStorageVersionHash)) {
            return false;
        }
        if (!Objects.equals(this.lastHeartbeatTime, that.lastHeartbeatTime)) {
            return false;
        }
        if (!Objects.equals(this.persistedStorageVersionHashes, that.persistedStorageVersionHashes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCurrentStorageVersionHash() {
        return this.currentStorageVersionHash;
    }

    public String getFirstPersistedStorageVersionHash() {
        return this.persistedStorageVersionHashes.get(0);
    }

    public String getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public String getLastPersistedStorageVersionHash() {
        return this.persistedStorageVersionHashes.get(this.persistedStorageVersionHashes.size() - 1);
    }

    public String getMatchingPersistedStorageVersionHash(Predicate<String> predicate) {
        for (String item : this.persistedStorageVersionHashes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPersistedStorageVersionHash(int index) {
        return this.persistedStorageVersionHashes.get(index);
    }

    public List<String> getPersistedStorageVersionHashes() {
        return this.persistedStorageVersionHashes;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCurrentStorageVersionHash() {
        return this.currentStorageVersionHash != null;
    }

    public boolean hasLastHeartbeatTime() {
        return this.lastHeartbeatTime != null;
    }

    public boolean hasMatchingPersistedStorageVersionHash(Predicate<String> predicate) {
        for (String item : this.persistedStorageVersionHashes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPersistedStorageVersionHashes() {
        return this.persistedStorageVersionHashes != null && !this.persistedStorageVersionHashes.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.currentStorageVersionHash, this.lastHeartbeatTime, this.persistedStorageVersionHashes, this.additionalProperties);
    }

    public A removeAllFromPersistedStorageVersionHashes(Collection<String> items) {
        if (this.persistedStorageVersionHashes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.persistedStorageVersionHashes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromPersistedStorageVersionHashes(String ... items) {
        if (this.persistedStorageVersionHashes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.persistedStorageVersionHashes.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToPersistedStorageVersionHashes(int index, String item) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        this.persistedStorageVersionHashes.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentStorageVersionHash != null) {
            sb.append("currentStorageVersionHash:");
            sb.append(this.currentStorageVersionHash);
            sb.append(",");
        }
        if (this.lastHeartbeatTime != null) {
            sb.append("lastHeartbeatTime:");
            sb.append(this.lastHeartbeatTime);
            sb.append(",");
        }
        if (this.persistedStorageVersionHashes != null && !this.persistedStorageVersionHashes.isEmpty()) {
            sb.append("persistedStorageVersionHashes:");
            sb.append(this.persistedStorageVersionHashes);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCurrentStorageVersionHash(String currentStorageVersionHash) {
        this.currentStorageVersionHash = currentStorageVersionHash;
        return (A)((Object)this);
    }

    public A withLastHeartbeatTime(String lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
        return (A)((Object)this);
    }

    public A withPersistedStorageVersionHashes(List<String> persistedStorageVersionHashes) {
        if (persistedStorageVersionHashes != null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
            for (String item : persistedStorageVersionHashes) {
                this.addToPersistedStorageVersionHashes(item);
            }
        } else {
            this.persistedStorageVersionHashes = null;
        }
        return (A)((Object)this);
    }

    public A withPersistedStorageVersionHashes(String ... persistedStorageVersionHashes) {
        if (this.persistedStorageVersionHashes != null) {
            this.persistedStorageVersionHashes.clear();
            this._visitables.remove((Object)"persistedStorageVersionHashes");
        }
        if (persistedStorageVersionHashes != null) {
            for (String item : persistedStorageVersionHashes) {
                this.addToPersistedStorageVersionHashes(item);
            }
        }
        return (A)((Object)this);
    }
}

